<?php

namespace App\Http\Controllers;

use App\Models\Evaluation;
use App\Models\Etape;
use App\Models\Activite;
use App\Models\Action;
use App\Models\Programme;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EvaluationsController extends Controller
{
	public function index() {
		
		 try {
		  $user = Auth::user();
			   $groupId = $user->usergroup_id;
		 
		 if ($groupId == 5 || $groupId == 6) {
					   $evaluations = Evaluation::select('evaluations.*')
		
							  ->join('activites', 'activites.id', '=', 'evaluations.activite_id')
							  ->join('actions', 'actions.id', '=', 'activites.action_id')
							  ->join('programmes', 'programmes.id', '=', 'actions.programme_id')
							  ->leftJoin('structure_activite', 'structure_activite.activite_id', '=', 'activites.id')
							  ->join('responsablestructures', function ($join) {
								  $join->on('responsablestructures.structure_id', '=', 'activites.structure_id')
									   ->orOn('responsablestructures.structure_id', '=', 'structure_activite.structure_id');
							  })
							  ->where('responsablestructures.user_id', $user->id)
							  ->with(['activite', 'prevision', 'etape'])
							  ->distinct()
							  ->orderBy('evaluations.date_reference', 'asc')
							  ->get();
					
		}
				 else {
			$evaluations = Evaluation::with('activite', 'prevision', 'etape')
				->orderBy('date_reference', 'asc')
				->get();}
			return view('evaluations.index', compact('evaluations'));
		} catch (\Exception $e) {
			return redirect()->back()->with('error', 'Erreur lors du chargement des évaluations : ' . $e->getMessage());
		}
	}
  
  
    public function show($id) {
	return Evaluation::findOrFail($id); 
	}
	

    public function store(Request $request, $activiteId)
	{
     try {
			// Récupérer les données JSON correctement
			$data = $request->json()->all();

			Log::info('Tentative d’enregistrement évaluation', $request->all());

			// Validation
			$validated = validator($data, [
				'previsionactivite_id' => 'required|integer',
				'etape_id' => 'nullable|exists:etapes,id',
				'extrant_id' => 'nullable|exists:extrants,id',
				'taux_prevision' => 'required|numeric',
				'taux_realisation' => 'required|numeric',
				//'date_evaluation' => 'required|date',
				'date_reference' => 'sometimes|date',
				'date_evaluation' => 'nullable|date',
			])->validate();

			$evaluation = Evaluation::create([
				'activite_id' => $activiteId,
				'previsionactivite_id' => $validated['previsionactivite_id'],
				'extrant_id' => $validated['extrant_id'],
				'taux_prevision' => $validated['taux_prevision'],
				'taux_realisation' => $validated['taux_realisation'],
				'date_reference' => $validated['date_reference'],
				'date_evaluation' => now(),
				'valide' => false,
				'commentaire' => null,
				'created_at' => now(),
			]);

			Log::info('Évaluation créée avec succès', ['id' => $evaluation->id]);

			return response()->json(['success' => true, 'id' => $evaluation->id]);
		} catch (\Exception $e) {
			Log::error('Erreur enregistrement évaluation', ['message' => $e->getMessage()]);
			return response()->json(['success' => false, 'message' => $e->getMessage()]);
		}
	}


    /**
     * Recherche une évaluation par prévision
     */
    public function findByPrevision($previsionId)
    {
        /*$evaluation = Evaluation::where('previsionactivite_id', $previsionId)->first();

        if ($evaluation) {
            return response()->json(['success' => true, 'id' => $evaluation->id]);
        }
        return response()->json(['success' => false]);*/
           try {
            $evaluation = Evaluation::where('previsionactivite_id', $previsionId)->first();
            if ($evaluation) {
                return response()->json(['success' => true, 'id' => $evaluation->id]);
            }
            return response()->json(['success' => false]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Erreur : ' . $e->getMessage()]);
        }
    }

    /**
     * Validation d’une évaluation
     */
    public function valider($id)
    {
        try {
            $evaluation = Evaluation::findOrFail($id);
            $evaluation->valide = true;
            $evaluation->updated_at = now();
            $evaluation->save();

           return redirect()->back()->with('success', 'Évaluation validée.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Échec d\'activation.');
        }
    }

	public function edit($id)
	{
		/*$evaluation = Evaluation::with('activite', 'prevision')->findOrFail($id);
		$etapes = Etape::where('groupeactivite_id', $evaluation->activite->groupe_id)->get();
		
		if($evaluation->valide){
			return redirect()->back()->with('error', 'Impossible car l\'evaluation est déjà validée.');
		}
		
		return view('evaluations.edit', compact('evaluation', 'etapes')); */
     try {
            $evaluation = Evaluation::with('activite', 'prevision')->findOrFail($id);
            if ($evaluation->valide) {
                return redirect()->back()->with('error', 'Impossible, évaluation déjà validée.');
            }
            $etapes = Etape::where('groupeactivite_id', $evaluation->activite->groupe_id)->get();
            return view('evaluations.edit', compact('evaluation', 'etapes'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’édition : ' . $e->getMessage());
        }
	}


    public function update(Request $request, $id)
    {
       /* $eval = Evaluation::findOrFail($id);
		if($eval->valide){
			return redirect()->back()->with('error', 'Impossible car l\'evaluation est déjà validée.');
		}
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'etape_id' => 'required|integer',
            'previsionactivite_id' => 'required|integer',
			'date_reference' => 'sometimes|date',
			'date_evaluation' => 'nullable|date',
            'commentaire' => 'nullable|string',
        ]);
		$data['taux_realisation'] = $niveauExec = Etape::where('id', $data['etape_id'])->value('niveauexec');
		$data['date_evaluation'] = now();
		
        if($eval->update($data)) {
			return redirect()
				->route('activites.evaluate', $eval->activite_id)
				->with('success', 'Données mise à jour avec succès.');
		}else{
			return redirect()->back()->with('error', 'Echec.');
		}*/
    try {
            $eval = Evaluation::findOrFail($id);
            if ($eval->valide) {
                return redirect()->back()->with('error', 'Impossible, évaluation déjà validée.');
            }

            $data = $request->validate([
                'activite_id' => 'required|integer',
                'etape_id' => 'required|integer',
                'previsionactivite_id' => 'required|integer',
                'date_reference' => 'sometimes|date',
                'date_evaluation' => 'nullable|date',
                'commentaire' => 'nullable|string',
            ]);

            $data['taux_realisation'] = Etape::where('id', $data['etape_id'])->value('niveauexec');
            $data['date_evaluation'] = now();

            $eval->update($data);

            return redirect()
                ->route('activites.evaluate', $eval->activite_id)
                ->with('success', 'Évaluation mise à jour avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour : ' . $e->getMessage());
        }
        
    }

    public function destroy($id) {
		
	/*	$evaluation = Evaluation::findOrFail($id);
		if($evaluation->valide){
			return redirect()->back()->with('error', 'Echec, évaluation déjà validé.');
		}
		
		if($evaluation->delete())
		{
			return redirect()
					->route('activites.evaluate', $evaluation->activite_id)
					->with('success', 'Données supprimées avec succès.');
		}else {
			return redirect()->back()->with('error', 'Echec.');
		}*/
      try {
            $evaluation = Evaluation::findOrFail($id);
            if ($evaluation->valide) {
                return redirect()->back()->with('error', 'Impossible, évaluation déjà validée.');
            }

            $evaluation->delete();

            return redirect()
                ->route('activites.evaluate', $evaluation->activite_id)
                ->with('success', 'Évaluation supprimée avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la suppression : ' . $e->getMessage());
        }
	}
  
  
}
