<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EvaluationStructure extends Model
{
    use HasFactory;

    protected $table = 'evaluationstructures';
    protected $primaryKey = 'id';

    protected $fillable = [
        'teaj',
        'teacj',
        'teadj',
        'anneeref',
        'structure_id',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function structure()
    {
        return $this->belongsTo(Structure::class, 'structure_id', 'id');
    }
}
