<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ModeleActivite extends Model
{
    use HasFactory;

    protected $table = 'modeleactivites';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'groupeactivite_id',
        'description',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    // Relation avec GroupeActivite
    public function groupeactivite()
    {
        return $this->belongsTo(GroupeActivite::class, 'groupeactivite_id', 'id');
    }

    // Relation avec Etapes
    public function etapes()
    {
        return $this->hasMany(Etape::class, 'modeleactivite_id', 'id')->orderBy('ordre', 'asc');;
    }
	
	protected static function boot()
    {
        parent::boot();

        static::deleting(function ($modele) {
            if ($modele->activites()->exists()) {
                throw new \Exception("Suppression impossible : ce modèle possède encore des activités associées.");
            }
        });
    }

    public function activites()
    {
        return $this->hasMany(Activite::class, 'modele_id', 'id');
    }
}
