<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pointfocal extends Model
{
    use HasFactory;

    protected $table = 'pointfocals';
    protected $primaryKey = 'id';

    protected $fillable = [
        'structure_id',
        'user_id',
        'datedebut',
        'datefin',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    // Relation avec Structure
    public function structure()
    {
        return $this->belongsTo(Structure::class, 'structure_id', 'id');
    }

    // Relation avec User
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
