<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $users = [
            [
                'name' => 'DGESS SuperAdmin',
                'email' => 'superadmin@example.com',
                'password' => Hash::make('SuperAdmin123'),
                'usergroup_id' => 1, // SuperAdmin (DGESS)
            ],
            [
                'name' => 'DGSI SecurityAdmin',
                'email' => 'securityadmin@example.com',
                'password' => Hash::make('Security123'),
                'usergroup_id' => 2, // SecurityAdmin (DGSI)
            ],
            [
                'name' => 'Programme Manager 1',
                'email' => 'programmanager1@example.com',
                'password' => Hash::make('ProgManager123'),
                'usergroup_id' => 3, // ProgramManager
            ],
            [
                'name' => 'Structure Manager 1',
                'email' => 'structuremanager1@example.com',
                'password' => Hash::make('StructManager123'),
                'usergroup_id' => 4, // StructureManager
            ],
            [
                'name' => 'Point Focal 1',
                'email' => 'pointfocal1@example.com',
                'password' => Hash::make('PointFocal123'),
                'usergroup_id' => 5, // PointFocal
            ],
        ];

        foreach ($users as $u) {
            User::create($u);
        }
    }
}
