@extends('layouts.app')
@section('title', 'Action')

@section('content')
<div class="pagetitle">
    <h1>Modifier une Action</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item">Actions</li>
            <li class="breadcrumb-item active">Modifier</li>
        </ol>
    </nav>
</div><!-- End Page Title -->

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Formulaire de modification d'une action</h5>

                    <form method="POST" action="{{ route('actions.update', $action->id) }}">
                        @csrf
                        @method('POST')

                        <div class="row g-3">

                            {{-- Programme --}}
                            <div class="col-md-6">
                                <label class="form-label">Programme</label>
                                <select name="programme_id" class="form-select" required>
                                    <option value="">-- Sélectionner un programme --</option>
                                    @foreach ($programmes as $programme)
                                        <option value="{{ $programme->id }}" {{ $programme->id == $action->programme_id ? 'selected' : '' }}>
                                            {{ $programme->nom }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Code --}}
                            <div class="col-md-6">
                                <label class="form-label">Code</label>
                              
                                <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code"  value="{{ old('code', $action->code) }}" required>
            @error('code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
                            </div>

                            {{-- Nom --}}
                            <div class="col-md-12">
                                <label class="form-label">Nom</label>
                               
                                            <input type="text" class="form-control @error('nom') is-invalid @enderror" id="nom" name="nom"  value="{{ old('nom', $action->nom) }}" required>
            @error('nom')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
                            </div>

                            {{-- Description --}}
                            <div class="col-12">
                                <label class="form-label">Description</label>
                                
                                 <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" >{{ old('description', $action->description) }}}</textarea>
        @error('description')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
                            </div>

                            {{-- Boutons --}}
                            @php
    $usergroupId = Auth::user()->usergroup_id;
@endphp
@if($usergroupId != 3)
	<div class="text-center">
                                <button type="submit" class="btn btn-primary">Mettre à jour</button>
                                <a href="{{ route('actions.index') }}" class="btn btn-secondary">Annuler</a>
                            </div>
@endif
                            

                        </div>
                    </form>

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
