@extends('layouts.app')

@section('title', 'Type Activte')

@section('content')
 <div class="pagetitle">
      <h1>Modification d'un type d'activité</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
          <li class="breadcrumb-item">Type Activite</li>
          <li class="breadcrumb-item active">Modification</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <section class="section">
      <div class="row">
        <div class="col-lg-12">
<div class="card">
  <div class="card-body">
    <h5 class="card-title">Modifier le type d’activité</h5>

    <form method="POST" action="{{ route('modeleactivites.update', $modeleactivite->id) }}">
      @csrf
      @method('POST')
	  
	  <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Groupe d'activité</label>
			<select name="groupeactivite_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($groupeactivites as $g)
                    <option value="{{ $g->id }}" {{ $g->id == $modeleactivite->groupeactivite_id ? 'selected' : '' }}>
					{{ $g->nom }}</option>
                  @endforeach
            </select>
        </div>
	  </div>
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control" value="{{ old('code', $modeleactivite->code) }}" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Nom</label>
          <input type="text" name="nom" class="form-control" value="{{ old('nom', $modeleactivite->nom) }}" required>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="description" class="form-control">{{ old('description', $modeleactivite->description) }}</textarea>
        </div>
      </div>

      <div class="mt-3">
        <button type="submit" class="btn btn-primary">Mettre à jour</button>
        <a href="{{ route('modeleactivites.index') }}" class="btn btn-secondary">Annuler</a>
      </div>
    </form>
  </div>
</div>>
</div>

        </div>
      </div>
    </section>
@endsection

