@extends('layouts.app')

@section('title', 'Programmes')

@section('content')
<div class="pagetitle">
    <h1>Programmes</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Programmes</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    @php
                        $usergroupId = Auth::user()->usergroup_id;
						$user_rps = Auth::user()->responsableProgrammes->pluck('id')->toArray();
                    @endphp

                    @if(in_array($usergroupId , [1, 2]))
                        <h5 class="card-title">
                            <a href="{{ route('programmes.create') }}" class="btn btn-primary rounded-pill">
                                <i class="bi bi-plus-circle"></i> Ajouter
                            </a>
                        </h5>
                    @endif

                   
                 
                    	@isset($programmesrp)
  <h3 class="mb-4">Vos programmes</strong></h3>

                   <table id="example1" class="table table-custom">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Actif</th>
                                <th>Ouvert</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($programmesrp as $programme)
                                <tr>
                                    <td>{{ $programme->code }} : {{ $programme->nom }}</td>
                                    <td>{{ Str::limit($programme->description, 30) }}</td>

                                    <td>
                                        @if(in_array($usergroupId, [3,5,6]))
                                            <button class="btn-sm-status {{ $programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                                                {{ $programme->actif ? 'Oui' : 'Non' }}
                                            </button>
                                        @endif
                                        @if(in_array($usergroupId, [1,2,4]))
                                            <a href="{{ route('programmes.fonctactif', $programme->id) }}" 
                                               class="btn-sm-status {{ $programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                                {{ $programme->actif ? 'Oui' : 'Non' }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>
                                        @if(in_array($usergroupId, [3,5,6]))
                                            <button class="btn-sm-status {{ $programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                                                {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
                                            </button>
                                        @endif
                                        @if(in_array($usergroupId, [1,2]) || ($usergroupId == 4 && in_array($programme->id, $user_rps)))
                                            <a href="{{ route('programmes.fonctouvert', $programme->id) }}" 
                                               class="btn-sm-status {{ $programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                                {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>
                                        <a href="{{ route('programmes.show', $programme->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>

                                        @if(in_array($usergroupId, [2])) 
                                            <a href="{{ route('programmes.edit', $programme->id) }}" class="btn-sm-status btn-sm-status-warning">
                                                <i class="bi bi-pen"></i>
                                            </a>
                                            <a href="{{ route('programmes.destroy', $programme->id) }}" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce programme ?')">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </br>  </br>  </br>
@endisset
                    <!-- End Table -->
                      
                    <h3 class="mb-4">Programmes</strong></h3>
                      <button onclick="exportTableToExcel('example1', 'programmes.xlsx', {includeColumns: [0,1,2,3]})" 
        class="btn btn-success">
    Exporter en Excel
</button>
                   <table id="example1" class="table table-custom">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Actif</th>
                                <th>Ouvert</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($programmes as $programme)
                                <tr>
                                    <td>{{ $programme->code }} : {{ $programme->nom }}</td>
                                    <td>{{ Str::limit($programme->description, 30) }}</td>

                                    <td>
                                        @if(in_array($usergroupId, [3,5,6,4]))
                                            <button class="btn-sm-status {{ $programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                                                {{ $programme->actif ? 'Oui' : 'Non' }}
                                            </button>
                                        @endif
                                        @if(in_array($usergroupId, [1,2]))
                                            <a href="{{ route('programmes.fonctactif', $programme->id) }}" 
                                               class="btn-sm-status {{ $programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                                {{ $programme->actif ? 'Oui' : 'Non' }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>
                                        @if(in_array($usergroupId, [3,5,6,4]))
                                            <button class="btn-sm-status {{ $programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                                                {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
                                            </button>
                                        @endif
                                        @if(in_array($usergroupId, [1,2]))
                                            <a href="{{ route('programmes.fonctouvert', $programme->id) }}" 
                                               class="btn-sm-status {{ $programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                                {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>
                 
                                        @if(in_array($usergroupId, [1,2]))
                                                                 <a href="{{ route('programmes.show', $programme->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
                                        @endif
                                        @if(in_array($usergroupId, [3,5,6,4]))
                                                                 <a href="{{ route('programmes.showrp', $programme->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
                                        @endif

                                        @if(in_array($usergroupId, [2])) 
                                            <a href="{{ route('programmes.edit', $programme->id) }}" class="btn-sm-status btn-sm-status-warning">
                                                <i class="bi bi-pen"></i>
                                            </a>
                                            <a href="{{ route('programmes.destroy', $programme->id) }}" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce programme ?')">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
