@extends('layouts.app')
@section('title', 'Structure')

@section('content')

<div class="pagetitle">
    <h1>Détails de la structure</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ url('index.html') }}">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ url('structures') }}">Structure</a></li>
            <li class="breadcrumb-item active">Détails</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">

            {{-- Titre Structure --}}
            <h3 class="mb-4">Structure : <strong>{{ $structure->nom }}</strong></h3>

            {{-- Message Session --}}
            @if(Session::has('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ Session::get('status') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
			
			@php
				$usergroupId = Auth::user()->usergroup_id;
			@endphp

			{{-- Informations générales --}}
			<div class="row justify-content-start mb-4">
				<div class="col-md-9"> {{-- largeur 3/4 --}}
					<div class="callout callout-primary p-3 border border-primary rounded">
						<h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
						<ul class="list-group list-group-flush">
							<li class="list-group-item d-flex justify-content-between">
								<b>Code :</b> <span>{{ $structure->code }}</span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Intitulé :</b> <span>{{ $structure->nom }}</span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Détails :</b> <span>{{ $structure->description }}</span>
							</li>

							{{-- Statut Actif --}}
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Structure activée :</b>
								<span>
									@if(in_array($usergroupId, [1,2]))
										<a href="{{ route('structures.fonctactif', $structure->id) }}" class="btn btn-sm {{ $structure->actif ? 'btn-success' : 'btn-secondary' }}">
											{{ $structure->actif ? 'OUI' : 'NON' }}
										</a>
									@else
										<button class="btn btn-sm {{ $structure->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
											{{ $structure->actif ? 'OUI' : 'NON' }}
										</button>
									@endif
								</span>
							</li>

							{{-- Responsable structure --}}
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Responsable structure (RS) :</b>
								<span>
									@if(in_array($usergroupId, [1,2]))
										@isset($structure->responsable)
											{{ $structure->responsable->name }} ({{ $structure->responsable->email }})
											<a href="{{ route('structures.rsremove', $structure->id) }}" onclick="return confirm('Enlever ce RS ?')" class="text-danger ms-2">X</a>
										@else
											Non désigné
											<a href="{{ route('users.rpcreate', ['level' => 'respstruct', 'id' => $structure->id]) }}" class="btn btn-warning btn-sm ms-2">
												<i class="bi bi-plus-circle"></i> Choisir/Modifier RS
											</a>
										@endisset
									@endif
								</span>
							</li>
							{{-- Point focal --}}
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Point focal (PF) :</b>
								<span>
									@if(in_array($usergroupId, [1,2]))
										@isset($structure->pointfocal)
											{{ $structure->pointfocal->name }} ({{ $structure->pointfocal->email }})
											<a href="{{ route('structures.pfremove', $structure->id) }}" onclick="return confirm('Enlever ce PF ?')" class="text-danger ms-2">X</a>
										@else
											Non désigné
											<a href="{{ route('users.rpcreate', ['level' => 'ptfocal', 'id' => $structure->id]) }}" class="btn btn-danger btn-sm ms-2">
												<i class="bi bi-plus-circle"></i> Choisir/Modifier PF
											</a>
										@endisset
									@endif
								</span>
							</li>
						</ul>
					</div>
				</div>
			</div>

            {{-- Historique des RS --}}
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des RS</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Responsable</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($structure->responsablearchives ?? [] as $resp)
                        <tr>
                            <td>{{ $resp->responsable }}</td>
                            <td>{{ $resp->datedebut }}</td>
                            <td>{{ $resp->datefin ?? 'En cours' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
			{{-- Historique des PFs --}}
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des PFs</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Point focal</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($structure->pointfocalarchives ?? [] as $pf)
                        <tr>
                            <td>{{ $pf->pointfocal }}</td>
                            <td>{{ $pf->datedebut }}</td>
                            <td>{{ $pf->datefin ?? 'En cours' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection
