@extends('layouts.app')

@section('title', 'Utilisateurs')

@section('content')
<div class="pagetitle">
  <h1>Ajout d’un Utilisateur</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Accueil</a></li>
      <li class="breadcrumb-item">Utilisateurs</li>
      <li class="breadcrumb-item active">Ajout</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Ajouter un utilisateur</h5>

          <form method="POST" action="{{ route('users.store') }}">
            @csrf
            <div class="row g-3">

              <div class="col-md-6">
                <label class="form-label">Nom complet</label>
                <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                @error('name') <small class="text-danger">{{ $message }}</small> @enderror
              </div>

              <div class="col-md-6">
                <label class="form-label">Adresse e-mail</label>
                <input type="email" name="email" class="form-control" value="{{ old('email') }}" required>
                @error('email') <small class="text-danger">{{ $message }}</small> @enderror
              </div>

              <div class="col-md-6">
                <label class="form-label">Mot de passe</label>
                <input type="password" name="password" class="form-control" required>
                @error('password') <small class="text-danger">{{ $message }}</small> @enderror
              </div>

              <div class="col-md-6">
                <label class="form-label">Groupe utilisateur</label>
                <select name="usergroup_id" class="form-select" required>
                  <option value="">-- Sélectionner un groupe --</option>
                  @foreach($usergroups as $group)
                      <option value="{{ $group->id }}" {{ old('usergroup_id') == $group->id ? 'selected' : '' }}>
                          {{ $group->nom }}
                      </option>
                  @endforeach
                </select>
                @error('usergroup_id') <small class="text-danger">{{ $message }}</small> @enderror
              </div>

              <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
                <button type="reset" class="btn btn-secondary">Réinitialiser</button>

              </div>

            </div>
          </form>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
