

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">Ajouter une prévision pour l'activité #<?php echo e($activiteid); ?></h2>

    
    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('previsionactivites.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <input type="hidden" name="activite_id" value="<?php echo e($activiteid); ?>">
        <input type="hidden" name="extrant_id" value="<?php echo e($extrant->id); ?>">
        <input type="hidden" name="ordreevaluation" value="<?php echo e(old('ordreevaluation', $nextOrdre)); ?>">

        <input type="text" class="form-control mb-3" value="<?php echo e($extrant->nom); ?>" disabled>

        <div class="mb-3">
            <label for="niveaucible" class="form-label">Niveau cible (%)</label>
            <input type="number" name="niveaucible" id="niveaucible"
                   class="form-control <?php $__errorArgs = ['niveaucible'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                   step="0.01" min="0" max="100" required
                   value="<?php echo e(old('niveaucible')); ?>">
            <?php $__errorArgs = ['niveaucible'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="mb-3">
            <label for="dateevaluation" class="form-label">Date d'évaluation</label>
            <input type="date" name="dateevaluation" id="dateevaluation"
                   class="form-control <?php $__errorArgs = ['dateevaluation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                   required value="<?php echo e(old('dateevaluation')); ?>">
            <?php $__errorArgs = ['dateevaluation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <button type="submit" class="btn btn-primary">Enregistrer</button>
        <a href="<?php echo e(route('activites.planning', $activiteid)); ?>" class="btn btn-secondary">Annuler</a>
    </form>
</div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const input = document.getElementById('niveaucible');
    input.addEventListener('input', function() {
        let val = parseFloat(this.value);
        if (val > 100) this.value = 100;
        else if (val < 0) this.value = 0;
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/previsionactivites/create.blade.php ENDPATH**/ ?>