<?php $__env->startSection('title', 'Utilisateurs'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Liste des Utilisateurs</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Utilisateurs</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">
        <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary rounded-pill">
          <i class="bi bi-plus-circle"></i> Nouvel utilisateur
        </a>
      </h5>

       <button onclick="exportTableToExcel('example1', 'utilisateurs.xlsx', {includeColumns: [0,1,2,3]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>

     <table id="example1" class="table table-custom">
        <thead>
          <tr>
            <th>Nom</th>
            <th>Email</th>
            <th>Groupe</th>
            <th>Actif</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($user->name); ?></td>
            <td><?php echo e($user->email); ?></td>
            <td><?php echo e($user->usergroup ? $user->usergroup->nom : 'N/A'); ?></td>
            <td>
              <a href="<?php echo e(route('users.actif', $user->id)); ?>" 
                 class="btn-sm-status <?php echo e($user->is_active ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                <?php echo e($user->is_active ? 'Oui' : 'Non'); ?>

              </a>
            </td>
            <td>
              <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn-sm-status btn-sm-status-warning">
                <i class="bi bi-pen"></i>
              </a>
              <a href="<?php echo e(route('users.destroy', $user->id)); ?>"
                 class="btn-sm-status btn-sm-status-danger"
                 onclick="return confirm('Supprimer cet utilisateur ?')">
                <i class="bi bi-trash"></i>
              </a>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/users/index.blade.php ENDPATH**/ ?>