<?php $__env->startSection('title', 'Programme'); ?>

<?php $__env->startSection('content'); ?>

<div class="pagetitle">
    <h1>Détails du Programme</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(url('index.html')); ?>">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('programmes')); ?>">Programmes</a></li>
            <li class="breadcrumb-item active">Détails</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">

            
            <h3 class="mb-4">Programme : <strong><?php echo e($programme->nom); ?></strong></h3>

            
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(Session::get('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
			
			<?php
				$usergroupId = Auth::user()->usergroup_id;
				$user_rs_ids = Auth::user()->responsablestructures->pluck('structure_id')->toArray();
				$user_pf_ids = Auth::user()->pointfocaux->pluck('structure_id')->toArray();
			?>

			
			<div class="row justify-content-start mb-4">
				<div class="col-md-9"> 
					<div class="callout callout-primary p-3 border border-primary rounded">
						<h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
						<ul class="list-group list-group-flush">
							<li class="list-group-item d-flex justify-content-between">
								<b>Code :</b> <span><?php echo e($programme->code); ?></span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Intitulé :</b> <span><?php echo e($programme->nom); ?></span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Détails :</b> <span><?php echo e($programme->description); ?></span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Programme activé :</b>
								<span>
							
										<button class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($programme->actif ? 'OUI' : 'NON'); ?>

										</button>
									
								</span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Ouvert (en élaboration/revu) :</b>
								<span>
							
										<button class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($programme->ouvert ? 'OUI' : 'NON'); ?>

										</button>
									
								</span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Responsable programme :</b>
								<span>
									<?php if(isset($programme->user)): ?>
											<?php echo e($programme->user->name); ?> (<?php echo e($programme->user->email); ?>)
									<?php endif; ?>
								</span>
							</li>
						</ul>
					</div>
				</div>
			</div>


            
            
          
         

            
            <div class="callout callout-danger mb-4 p-3 border border-danger rounded">
                <h5 class="mb-3 text-danger"><u>Liste des actions</u></h5>

              

                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Code</th>
                            <th>Libellé</th>
                            <th>Actif</th>
                            <th>Ouvert</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $programme->actions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<?php
							$action_structure_ids = $action->structures->pluck('id')->toArray();
						?>
						<?php if(in_array($usergroupId, [5,6]) && (!empty(array_intersect($user_rs_ids, $action_structure_ids)) || !empty(array_intersect($user_pf_ids, $action_structure_ids)))): ?>
                        <tr>
                            <td><?php echo e($action->code); ?></td>
                            <td><?php echo e($action->nom); ?></td>
                            <td class="text-center">
                            	<button class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($action->actif ? 'OUI' : 'NON'); ?>

										</button>
                            </td>
                            <td class="text-center">

                                      	<button class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($action->ouvert ? 'OUI' : 'NON'); ?>

										</button>
                            </td>
                            <td class="text-center">
								<a href="<?php echo e(route('actions.show', $action->id)); ?>" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
							</td>
                        </tr>
						<?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des RPs</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Responsable</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $programme->responsables ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($resp->user); ?></td>
                            <td><?php echo e($resp->datedebut); ?></td>
                            <td><?php echo e($resp->datefin ?? 'En cours'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/programmes/showrp.blade.php ENDPATH**/ ?>