<?php

namespace App\Http\Controllers;

use App\Models\ModeleActivite;
use App\Models\GroupeActivite;
use App\Models\Activite;
use Illuminate\Http\Request;

class ModeleActivitesController extends Controller
{
    public function index() {
	/*	$modeleactivites = ModeleActivite::with(['groupeactivite'])->get();
		return view('modeleactivites.index', compact('modeleactivites'));*/
    
     try {
            $modeleactivites = ModeleActivite::with(['groupeactivite'])->get();
            return view('modeleactivites.index', compact('modeleactivites'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement de la liste : ' . $e->getMessage());
        }
	}
	
    public function show($id)
    {
        /*$modeleactivite = ModeleActivite::with(['etapes', 'groupeactivite'])->findOrFail($id);
		$nbractivites = Activite::where('modele_id', $id)->where('valide', true)->count();
        //dd($modeleactivite, $nbractivites); die();
		return view('modeleactivites.show', compact('modeleactivite', 'nbractivites'));*/
     try {
            $modeleactivite = ModeleActivite::with(['etapes', 'groupeactivite'])->findOrFail($id);
            $nbractivites = Activite::where('modele_id', $id)->where('valide', true)->count();

            return view('modeleactivites.show', compact('modeleactivite', 'nbractivites'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage du modèle : ' . $e->getMessage());
        }
    }
	
	public function create()
    {
		/*$groupeactivites = GroupeActivite::all();
        return view('modeleactivites.create', compact('groupeactivites'));*/
        try {
            $groupeactivites = GroupeActivite::all();
            return view('modeleactivites.create', compact('groupeactivites'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire de création : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|string|max:20',
            'nom' => 'required|string|max:100',
            'groupeactivite_id' => 'required|integer',
            'description' => 'nullable|string',
        ]);
		
      /*  ModeleActivite::create($request->all());
		return redirect()->route('modeleactivites.index')->with('success', 'Données ajoutées avec succès.');*/
    
    try {
           

            $modele = new ModeleActivite($validated);
            if ($modele->save()) {
                return redirect()->route('modeleactivites.index')->with('success', 'Données ajoutées avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’enregistrement du modèle.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
	
	 public function edit($id)
    {
       /* $modeleactivite = ModeleActivite::findOrFail($id);
		$groupeactivites = GroupeActivite::all();
        return view('modeleactivites.edit', compact('modeleactivite', 'groupeactivites'));*/
         try {
            $modeleactivite = ModeleActivite::findOrFail($id);
            $groupeactivites = GroupeActivite::all();

            return view('modeleactivites.edit', compact('modeleactivite', 'groupeactivites'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire d’édition : ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
        $m = ModeleActivite::findOrFail($id);
        $data = $request->validate([
            'code' => 'sometimes|string|max:20' . $m->id,
            'nom' => 'sometimes|string|max:100',
            'groupeactivite_id' => 'sometimes|integer',
            'description' => 'nullable|string',
        ]);
       /* $m->update($data);
        return redirect()->route('modeleactivites.index')->with('success', 'Type d’activités modifié avec succès.');*/
        
         try {
        

           
            if ($m->update($data)) {
                return redirect()->route('modeleactivites.index')->with('success', 'Type d’activités modifié avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour du modèle.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function destroy($id) {
		ModeleActivite::findOrFail($id)->delete();
		
		try {
			$modele = ModeleActivite::findOrFail($id);
			$modele->delete();
			return redirect()->route('modeleactivites.index')->with('success', 'Type d’activités supprimé avec succès.');

		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
    
    
	}
	 
	public function actif($id)
    {
       /* $modeleactivite = ModeleActivite::findOrFail($id);
		$modeleactivite->is_active = !$modeleactivite->is_active;
		$modeleactivite->save();*/

        return redirect()->back()->with('success');
        
        try {
            $modeleactivite = ModeleActivite::findOrFail($id);
            $modeleactivite->is_active = !$modeleactivite->is_active;

            if ($modeleactivite->save()) {
                return redirect()->back()->with('success', 'État du modèle mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour de l’état.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    } 
}
