<?php

namespace App\Http\Controllers;

use App\Models\StructureAction;
use Illuminate\Http\Request;

class StructureActionsController extends Controller
{
    public function index($actionid, ) {
		return StructureAction::all(); 
	}

    public function attach($structureid, $actionid, $actionstate)
    {
		// $actionstate est un résultat du ET entre l'état OUVERT et ACTIF de l'action UNE Action doit être active et ouverte pour ajouter 
		if($actionstate == false){
			return redirect()->route('actions.show', $actionid)->with('error', 'L\'action doit être activée et ouverte aux modifications.');
		}
        $data = new StructureAction();
		$data->structure_id = $structureid;
		$data->action_id = $actionid;
		$data->datedebut = now();
		$data->is_active = true;
		
		//dd($data); die();
		
		if($data->save()){
			return redirect()->route('actions.show', $actionid)->with('success', 'Mise à jour effectuée.');
		}else{
			return redirect()->route('actions.show', $actionid)->with('error', 'Echec.');
		}
    }

    public function detach($id) { 
		$data = StructureAction::findOrFail($id);
		//dd($data); die();
		$data->is_active = false;
		$data->datefin = now();
		if($data->save()){
			return redirect()->route('actions.show', $data->action_id)->with('success', 'Mise à jour effectuée.');
		}else{
			return redirect()->route('actions.show', $data->action_id)->with('error', 'Echec.');
		} 
	}
}

