<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Resultat extends Model
{
    use HasFactory;

    protected $table = 'resultats';
    protected $primaryKey = 'id';

    protected $fillable = [
        'action_id',
        'nom',
        'description',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function action()
    {
        return $this->belongsTo(Action::class, 'action_id', 'id');
    }
	
	 // Relation avec Activites
    public function activites()
    {
        return $this->hasMany(Activite::class, 'resultat_id', 'id');
    }
}
