<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Usergroup;

class UsergroupSeeder extends Seeder
{
    public function run(): void
    {
        $usergroups = [
            [
                'nom' => 'SuperAdmin (DGESS)',
                'description' => 'Groupe administrateur fonctionnel. Possède tous les droits sur le système sauf ceux relatifs à l’administration technique. Il gère les programmes, leur activation/désactivation, leur ouverture/fermeture et la validation des activités et évaluations.'
            ],
            [
                'nom' => 'SecurityAdmin (DGSI)',
                'description' => 'Groupe administrateur technique. Dispose des droits sur l’administration et les paramètres système. Il a un accès en lecture seule sur les programmes, actions, activités et évaluations.'
            ],
            [
                'nom' => 'ProgramManager',
                'description' => 'Responsable de programme. Dispose des droits complets sur les actions, résultats et éléments de son programme. Peut modifier son programme sans pouvoir l’activer/désactiver ou l’ouvrir/fermer. Possède un accès en lecture seule sur les activités et détails du programme.'
            ],
            [
                'nom' => 'StructureManager',
                'description' => 'Responsable de structure. Dispose d’un accès en lecture seule sur les programmes, actions et activités concernant sa structure. Peut valider les activités et les évaluations associées à sa structure.'
            ],
            [
                'nom' => 'PointFocal',
                'description' => 'Point focal de structure. Dispose d’un accès en lecture sur les programmes, actions et activités de sa structure. Peut créer ou modifier une activité tant que le programme, l’action ou l’activité n’est pas fermé(e). Après création, l’activité est non validée jusqu’à validation par le Responsable de structure ou la DGESS. Peut aussi évaluer une activité, mais la validation de cette évaluation est assurée par le RS ou la DGESS.'
            ],
        ];

        foreach ($usergroups as $ug) {
            Usergroup::create($ug);
        }
    }
}
