@extends('layouts.app')

@section('title', 'Action')

@section('content')
<div class="pagetitle">
  <h1>Nouvelle Action</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Accueil</a></li>
      <li class="breadcrumb-item">Actions</li>
      <li class="breadcrumb-item active">Création</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Ajouter une nouvelle action</h5>

          <form method="POST" action="{{ route('actions.store') }}">
            @csrf

            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">Programme</label>
                <select name="programme_id" class="form-select" required>
                  <option value="">-- Sélectionner --</option>
                  @foreach ($programmes as $programme)
                    <option value="{{ $programme->id }}" {{ $progid == $programme->id ? 'selected' : '' }}>
                      {{ $programme->nom }}
                    </option>
                  @endforeach
                </select>
              </div>

              <div class="col-md-3">
                <label class="form-label">Code</label>
               
                    <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code"  value="{{ old('code') }}" required>
            @error('code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
              </div>

              <div class="col-md-9">
                <label class="form-label">Nom</label>
               
                 <input type="text" class="form-control @error('nom') is-invalid @enderror" id="nom" name="nom"  value="{{ old('nom') }}" required>
        @error('nom')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-12">
                <label class="form-label">Description</label>
                
                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" >{{ old('description') }}</textarea>
        @error('description')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="text-center">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
  <button type="reset" class="btn btn-secondary">Réinitialiser</button>               
              </div>
            </div>
          </form>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
