<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>@yield('title', 'Dashboard - NiceAdmin')</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="{{ asset('assets/img/logo-phaso.png') }}" rel="icon">
  <link href="{{ asset('assets/img/apple-touch-icon.png') }}" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/boxicons/css/boxicons.min.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/quill/quill.snow.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/quill/quill.bubble.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/remixicon/remixicon.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/simple-datatables/style.css') }}" rel="stylesheet">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="{{ asset('assets/js/excel-export.js') }}"></script>

  <!-- Template Main CSS File -->
  <link href="{{ asset('assets/css/style.css') }}" rel="stylesheet">

  <!-- =======================================================
  * Template Name: NiceAdmin
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Updated: Apr 20 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
	<<style>
		/* Sous-menus orange avec texte légèrement plus grand que normal mais plus petit que les menus principaux */
		.nav-content a {
			color: orange !important;
			font-size: 1.08rem; /* Ajustable selon ton goût */
		}

		/* Pour que les icônes et le texte restent alignés verticalement */
		.nav-content a i.bi-circle {
			font-size: 0.85rem; /* légèrement plus petit que le texte */
		}
	</style>
  <style>
                        /* Tableau stylisé */
                        .table-custom {
                            width: 100%;
                            border-collapse: collapse;
                            border: 1px solid #dee2e6;
                        }
                        .table-custom th,
                        .table-custom td {
                            border: 1px solid #dee2e6;
                            padding: 0.5rem 0.75rem;
                            vertical-align: middle;
                        }

                        /* En-tête sombre et centré */
                        .table-custom thead th {
                            background-color: #343a40;
                            color: #fff;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                            text-align: center; /* <-- centré */
                        }

                        /* Contenu des cellules justifié à gauche */
                        .table-custom tbody td {
                            text-align: left;
                        }

                        /* Lignes alternées et survol */
                        .table-custom tbody tr:nth-child(odd) {
                            background-color: #f8f9fa;
                        }
                        .table-custom tbody tr:hover {
                            background-color: #e9ecef;
                        }

                        /* Boutons stylisés */
                        .btn-sm-status {
                            padding: 0.25rem 0.5rem;
                            font-size: 0.85rem;
                            font-weight: bold;
                            border-radius: 0.25rem;
                            color: #fff;
                            text-align: center;
                        }
                        .btn-sm-status-info { background-color: #17a2b8; }
                        .btn-sm-status-danger { background-color: #dc3545; }
                         .btn-sm-status-success { background-color: #28a745; }
                        .btn-sm-status-secondary { background-color: #6c757d; }
                        .btn-sm-status-warning { background-color: #ffc107; color: #212529; }
                        .btn-sm-status-info { background-color: #17a2b8; }
                        .btn-sm-status-danger { background-color: #dc3545; }
                        .bg-blue { background-color: #007bff; }

                        .bg-red { background-color: #dc3545; }

                        .bg-orange {background-color: #fd7e14; }

                        .bg-green {background-color: #28a745; }
                           .ecart-faible { background-color: #d4edda; }   /* vert clair */
    .ecart-moyen { background-color: #a9dfbf;  }    /* vert moyen */
    .ecart-eleve { background-color: #28a745; color: #fff; }       /* vert foncé */
                    </style>
</head>

<body>

  <!-- ======= Header ======= -->
  <header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="index.html" class="logo d-flex align-items-center admin-logo">
        <img src="{{ asset('assets/img/logo-phaso.png') }}"  alt="">
        <span class="d-none d-lg-block">PLATEFORME DE SUIVI DU 
PTA DU MEF</span>
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

    <div class="search-bar">
      <form class="search-form d-flex align-items-center" method="POST" action="#">
        <input type="text" name="query" placeholder="Search" title="Enter search keyword">
        <button type="submit" title="Search"><i class="bi bi-search"></i></button>
      </form>
    </div><!-- End Search Bar -->

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">

        <li class="nav-item d-block d-lg-none">
          <a class="nav-link nav-icon search-bar-toggle " href="#">
            <i class="bi bi-search"></i>
          </a>
        </li><!-- End Search Icon-->

        <!--  <li class="nav-item dropdown">

          <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
            <i class="bi bi-bell"></i>
            <span class="badge bg-primary badge-number">4</span>
          </a><!-- End Notification Icon -->

         <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications">
            <li class="dropdown-header">
              You have 4 new notifications
              <a href="#"><span class="badge rounded-pill bg-primary p-2 ms-2">View all</span></a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-exclamation-circle text-warning"></i>
              <div>
                <h4>Lorem Ipsum</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>30 min. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-x-circle text-danger"></i>
              <div>
                <h4>Atque rerum nesciunt</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>1 hr. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-check-circle text-success"></i>
              <div>
                <h4>Sit rerum fuga</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>2 hrs. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="notification-item">
              <i class="bi bi-info-circle text-primary"></i>
              <div>
                <h4>Dicta reprehenderit</h4>
                <p>Quae dolorem earum veritatis oditseno</p>
                <p>4 hrs. ago</p>
              </div>
            </li>

            <li>
              <hr class="dropdown-divider">
            </li>
            <li class="dropdown-footer">
              <a href="#">Show all notifications</a>
            </li>

          </ul><!-- End Notification Dropdown Items -->

        </li><!-- End Notification Nav -->

      <!--  <li class="nav-item dropdown">

          <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
            <i class="bi bi-chat-left-text"></i>
            <span class="badge bg-success badge-number">3</span>
          </a><!-- End Messages Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow messages">
            <li class="dropdown-header">
              You have 3 new messages
              <a href="#"><span class="badge rounded-pill bg-primary p-2 ms-2">View all</span></a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="message-item">
              <a href="#">
                <img src="{{ asset('assets/img/messages-1.jpg') }}" alt="" class="rounded-circle">
                <div>
                  <h4>Maria Hudson</h4>
                  <p>Velit asperiores et ducimus soluta repudiandae labore officia est ut...</p>
                  <p>4 hrs. ago</p>
                </div>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="message-item">
              <a href="#">
                <img src="{{ asset('assets/img/messages-2.jpg') }}" alt="" class="rounded-circle">
                <div>
                  <h4>Anna Nelson</h4>
                  <p>Velit asperiores et ducimus soluta repudiandae labore officia est ut...</p>
                  <p>6 hrs. ago</p>
                </div>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="message-item">
              <a href="#">
                <img src="{{ asset('assets/img/messages-3.jpg') }}" alt="" class="rounded-circle">
                <div>
                  <h4>David Muldon</h4>
                  <p>Velit asperiores et ducimus soluta repudiandae labore officia est ut...</p>
                  <p>8 hrs. ago</p>
                </div>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li class="dropdown-footer">
              <a href="#">Show all messages</a>
            </li>

          </ul><!-- End Messages Dropdown Items -->

        </li><!-- End Messages Nav -->

        <li class="nav-item dropdown pe-3">

          <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
            <img src="{{ asset('assets/img/profile-img.png') }}" alt="Profile" class="rounded-circle">
            <span class="d-none d-md-block dropdown-toggle ps-2">{{ auth()->user()->name }}</span>
          </a><!-- End Profile Iamge Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
           <!--  <li class="dropdown-header">
              
              <span>Web Designer</span>
            </li>-->
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="users-profile.html">
                <i class="bi bi-person"></i>
                <span>My Profile</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="users-profile.html">
                <i class="bi bi-gear"></i>
                <span>Account Settings</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="pages-faq.html">
                <i class="bi bi-question-circle"></i>
                <span>Need Help?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
             <a class="dropdown-item d-flex align-items-center" href="{{ route('logout') }}"
                 onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                 <i class="bi bi-box-arrow-right"></i>
    		<span>Déconnexion</span>
	     </a>

		<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
    		@csrf
		</form>
            </li>

          </ul><!-- End Profile Dropdown Items -->
        </li><!-- End Profile Nav -->

      </ul>
    </nav><!-- End Icons Navigation -->

  </header><!-- End Header -->

  <!-- ======= Sidebar ======= -->
<aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">
        <li class="nav-item @if(request()->route()->getName() == 'dashboard') active @endif">
            <a class="nav-link" href="dashboard">
                <i class="bi bi-grid"></i>
                <span>Tableau de Bord</span>
            </a>
        </li>

        @if(!in_array(Auth::user()->usergroup_id, [4, 5, 6]))
        <!-- Section Paramètres Généraux -->
        <li class="nav-item">
            <a class="nav-link collapsed" data-bs-target="#parametres-nav" data-bs-toggle="collapse" href="#">
                <i class="bi bi-gear"></i><span>Paramètres Généraux</span><i class="bi bi-chevron-down ms-auto"></i>
            </a>
            <ul id="parametres-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
                <li>
                    <a href="{{ route('ministeres.index') }}" class="@if(request()->route()->getName() == 'ministeres.index') active @endif">
                        <i class="bi bi-circle"></i><span>Ministères</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('structures.index') }}" class="@if(request()->route()->getName() == 'structures.index') active @endif">
                        <i class="bi bi-circle"></i><span>Structures</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('typepartenaires.index') }}" class="@if(request()->route()->getName() == 'typepartenaires.index') active @endif">
                        <i class="bi bi-circle"></i><span>Types de partenaires</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('partenaires.index') }}" class="@if(request()->route()->getName() == 'partenaires.index') active @endif">
                        <i class="bi bi-circle"></i><span>Partenaires</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('csds.index') }}" class="@if(request()->route()->getName() == 'csds.index') active @endif">
                        <i class="bi bi-circle"></i><span>Cadres sectoriels de dialogues</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('groupeactivites.index') }}" class="@if(request()->route()->getName() == 'groupeactivites.index') active @endif">
                        <i class="bi bi-circle"></i><span>Groupes d'activités</span>
                    </a>
                </li>
            </ul>
        </li>
        @endif

        <!-- Section Programmes & Actions -->
        <li class="nav-item">
            <a class="nav-link collapsed" data-bs-target="#programmes-nav" data-bs-toggle="collapse" href="#">
                <i class="bi bi-kanban"></i><span>Programmes & Actions</span><i class="bi bi-chevron-down ms-auto"></i>
            </a>
            <ul id="programmes-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
                <li>
                    <a href="{{ route('programmes.index') }}" class="@if(request()->route()->getName() == 'programmes.index') active @endif">
                        <i class="bi bi-circle"></i><span>Programmes</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('actions.index') }}" class="@if(request()->route()->getName() == 'actions.index') active @endif">
                        <i class="bi bi-circle"></i><span>Actions</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('activites.index') }}" class="@if(request()->route()->getName() == 'activites.index') active @endif">
                        <i class="bi bi-circle"></i><span>Activités</span>
                    </a>
                </li>
            </ul>
        </li>

        @if(!in_array(Auth::user()->usergroup_id, [2, 4]))
        <!-- Section Tableau des prévisions et réalisation -->
        <li class="nav-item">
            <a class="nav-link collapsed" data-bs-target="#previsions-nav" data-bs-toggle="collapse" href="#">
                <i class="bi bi-graph-up-arrow"></i><span>Prévisions & Réalisations</span><i class="bi bi-chevron-down ms-auto"></i>
            </a>
            <ul id="previsions-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
                <li>
                    <a href="{{ route('previsionactivites.index') }}" class="@if(request()->route()->getName() == 'previsionactivites.index') active @endif">
                        <i class="bi bi-circle"></i><span>Tableau des prévisions</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('evaluations.index') }}" class="@if(request()->route()->getName() == 'evaluations.index') active @endif">
                        <i class="bi bi-circle"></i><span>Etats de réalisation</span>
                    </a>
                </li>
            </ul>
        </li>
        @endif

        @if(!in_array(Auth::user()->usergroup_id, [2, 4, 5, 6]))
        <!-- Section Administration -->
        <li class="nav-item">
            <a class="nav-link collapsed" data-bs-target="#admin-nav" data-bs-toggle="collapse" href="#">
                <i class="bi bi-shield-lock"></i><span>Administration</span><i class="bi bi-chevron-down ms-auto"></i>
            </a>
            <ul id="admin-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
                <li>
                    <a href="{{ route('usergroups.index') }}" class="@if(request()->route()->getName() == 'usergroups.index') active @endif">
                        <i class="bi bi-circle"></i><span>Groupes d'utilisateurs</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('users.index') }}" class="@if(request()->route()->getName() == 'users.index') active @endif">
                        <i class="bi bi-circle"></i><span>Utilisateurs</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('evenements.index') }}" class="@if(request()->route()->getName() == 'evenements.index') active @endif">
                        <i class="bi bi-circle"></i><span>Evènements</span>
                    </a>
                </li>
            </ul>
        </li>
        @endif
    </ul>
</aside>

<!-- End Sidebar-->

  <main id="main" class="main">
  @if (session('success'))
  <div class="alert alert-success bg-success text-light border-0 alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Fermer"></button>
  </div>
@endif

@if (session('error'))
  <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
    {{ session('error') }}
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Fermer"></button>
  </div>
@endif

	@yield('content')
    

  </main><!-- End #main -->

  <!-- ======= Footer ======= -->
  <footer id="footer" class="footer">
    <div class="copyright">
      &copy; Copyright 2025 <strong><span>MEF</span></strong>. Tous droits réservés
    </div>
    <div class="credits">
      <!-- All the links in the footer should remain intact. -->
      <!-- You can delete the links only if you purchased the pro version. -->
      <!-- Licensing information: https://bootstrapmade.com/license/ -->
      <!-- Purchase the pro version with working PHP/AJAX contact form: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/ -->
      Designed by <a href="https://esoftburkina.com/">Conçu par ESOFT</a>
    </div>
  </footer><!-- End Footer -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

 <!-- Vendor JS Files -->
  <script src="{{ asset('assets/vendor/apexcharts/apexcharts.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/chart.js/chart.umd.js') }}"></script>
  <script src="{{ asset('assets/vendor/echarts/echarts.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/quill/quill.js') }}"></script>
  <script src="{{ asset('assets/vendor/simple-datatables/simple-datatables.js') }}"></script>
  <script src="{{ asset('assets/vendor/tinymce/tinymce.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/php-email-form/validate.js') }}"></script>

  <!-- Template Main JS File -->
  <script src="{{ asset('assets/js/main.js') }}"></script>
  @yield('scripts')
	<script>
	document.addEventListener('DOMContentLoaded', function() {
		// Ouvre automatiquement la section contenant le lien actif
		const activeLink = document.querySelector('.nav-content a.active');
		if (activeLink) {
			const parentCollapse = activeLink.closest('.nav-content.collapse');
			if (parentCollapse) {
				parentCollapse.classList.add('show');
				const trigger = document.querySelector(`[data-bs-target="#${parentCollapse.id}"]`);
				if (trigger) {
					trigger.classList.remove('collapsed');
				}
			}
		}
	});
	</script>

</body>

</html>
