@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
    <h1>Natures d'activités</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Natures d'activités connues</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="{{ route('modeleactivites.create') }}" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                   

                    <table class="table datatable table-custom">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Nom</th>
                                <th>Groupe</th>
                                <th>Description</th>
                                <th>Statut</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($modeleactivites as $modeleactivite)
                                <tr>
                                    <td>{{ $modeleactivite->code }}</td>
                                    <td>{{ $modeleactivite->nom }}</td>
                                    <td>{{ $modeleactivite->groupeactivite->nom ?? '-' }}</td>
                                    <td>{{ $modeleactivite->description }}</td>
                                    <td>
                                        <a href="{{ route('modeleactivites.actif', $modeleactivite->id) }}" 
                                           class="btn-sm-status {{ $modeleactivite->is_active ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                           {{ $modeleactivite->is_active ? 'Actif' : 'Inactif' }}
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('modeleactivites.show', $modeleactivite->id) }}" class="btn-sm-status btn-sm-status-info">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="{{ route('modeleactivites.edit', $modeleactivite->id) }}" class="btn-sm-status btn-sm-status-info">
                                            <i class="bi bi-pen"></i>
                                        </a>
                                        <a href="{{ route('modeleactivites.destroy', $modeleactivite->id) }}" 
                                           class="btn-sm-status btn-sm-status-danger"
                                           onclick="return confirm('Supprimer cette nature d\'activité ?')">
                                           <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
