@extends('layouts.app')
@section('title', 'Utilisateurs')

@section('content')
<div class="pagetitle">
  <h1>Choisir un utilisateur</h1>
  <nav>
    <ol class="breadcrumb">
		<li class="breadcrumb-item">
		@If ($level=='program')
			<a href="{{ route('programmes.show', $id) }}"> Détail programme</a>
		@ElseIf ($level=='respstruct')
			<a href="{{ route('structures.show', $id) }}"> Détail structure</a>
		@ElseIf ($level=='ptfocal')
			<a href="{{ route('structures.show', $id) }}"> Détail structure</a>
		@Endif
			<li class="breadcrumb-item active">Utilisateurs</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="card">
    <div class="card-body">
       <table class="table datatable">
        <thead>
          <tr>
            <th>Nom</th>
            <th>Email</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($users as $user)
          <tr>
            <td>{{ $user->name }}</td>
            <td>{{ $user->email }}</td>
            <td>
              <a href="{{ route('users.rpadd', ['level' => $level, 'levelid' =>$id, 'userid'=>$user->id]) }}" class="btn btn-warning btn-sm" >
                <i class="bi bi-plus-circle"></i>
              </a> 
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>

    </div>
  </div>
</section>
@endsection

