<?php

namespace App\Http\Controllers;

use App\Models\Ministere;
use Illuminate\Http\Request;

class MinisteresController extends Controller
{
    public function index()
    {
        /*$ministeres = Ministere::all();
        return view('ministeres.index', compact('ministeres'));*/
         try {
            $ministeres = Ministere::all();
            return view('ministeres.index', compact('ministeres'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des ministères : ' . $e->getMessage());
        }
    }

    public function create()
    {
        //return view('ministeres.create');
          try {
            return view('ministeres.create');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire de création : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:ministeres,code',
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
        ]);

        /*Ministere::create($validated);

        return redirect()->route('ministeres.index')->with('success', 'Ministère ajouté avec succès.');*/
        
         try {
         

            $ministere = new Ministere($validated);
               if ($ministere->save()) {
                return redirect()->route('ministeres.index')->with('success', 'Ministère ajouté avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’ajout du ministère.');
            }

            
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ajout du ministère : ' . $e->getMessage());
        }
    }

    public function edit($id = 0)
    {
        /*$ministere = Ministere::find($id);

        return view('ministeres.edit', compact('ministere'));*/
         try {
            $ministere = Ministere::findOrFail($id);
            return view('ministeres.edit', compact('ministere'));
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('ministeres.index')->with('error', 'Ministère introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire d’édition : ' . $e->getMessage());
        }
    }

public function update(Request $request, $id)
{
    $ministere = Ministere::findOrFail($id);

    $validated = $request->validate([
        'code' => 'required|string|max:20',
        'nom' => 'required|string|max:100',
        'description' => 'nullable|string',
    ]);

   /* $ministere->update($validated);

    return redirect()->route('ministeres.index')->with('success', 'Ministère mis à jour avec succès.');*/
    
    try {
          

            

            if ($ministere->update($validated)) {
                return redirect()->route('ministeres.index')->with('success', 'Ministère mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour du ministère.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('ministeres.index')->with('error', 'Ministère introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour : ' . $e->getMessage());
        }
}

	public function destroy($id) {
		try {
			$ministere =Ministere::findOrFail($id);
		
       if (	$ministere->delete()) {
                return redirect()->route('ministeres.index')->with('success', 'Ministere supprimé avec succès.'); 
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression du ministère.');
            }
			
		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
	} 
}

