<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Partenaire extends Model
{
    use HasFactory;

    protected $table = 'partenaires';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'desctiption',
        'typepartenaire_id',
        'created_at',
        'updated_at',
    ];

    public $timestamps = true;

    public function typePartenaire()
    {
        return $this->belongsTo(TypePartenaire::class, 'typepartenaire_id', 'id');
    }

    public function financements()
    {
        return $this->hasMany(FinancementActivite::class, 'partenaire_id', 'id');
    }
}
