<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResponsableStructure extends Model
{
    use HasFactory;

    protected $table = 'responsablestructures';
    protected $primaryKey = 'id';

    protected $fillable = [
        'structure_id',
        'user_id',
        'datedebut',
        'datefin',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function structure()
    {
        return $this->belongsTo(Structure::class, 'structure_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
