@extends('layouts.app')

@section('title', 'Groupe Activités')

@section('content')
<div class="pagetitle">
    <h1>Groupe Activités</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Groupe Activités</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="{{ route('groupeactivites.create') }}" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                     <button onclick="exportTableToExcel('groupe-activite-table', 'groupe_activite.xlsx', {includeColumns: [0,1,2,3]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>
                  

                   <table class="table datatable table-custom" id="groupe-activite-table">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Nom</th>
                                <th>CSD</th>
                                <th>Description</th>
                                <th>Voir</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($groupeactivites as $groupeactivite)
                                <tr>
                                    <td>{{ $groupeactivite->code }}</td>
                                    <td>{{ $groupeactivite->nom }}</td>
                                    <td>{{ $groupeactivite->csd->nom ?? '-' }}</td>
                                    <td>{{ $groupeactivite->description }}</td>
                                    <td>
                                        <a href="{{ route('groupeactivites.show', $groupeactivite->id) }}" 
                                           class="btn-sm-status btn-sm-status-info">
                                           <i class="bi bi-eye"></i>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('groupeactivites.edit', $groupeactivite->id) }}" 
                                           class="btn-sm-status btn-sm-status-info">
                                           <i class="bi bi-pen"></i>
                                        </a>
                                        <a href="{{ route('groupeactivites.destroy', $groupeactivite->id) }}" 
                                           class="btn-sm-status btn-sm-status-danger"
                                           onclick="return confirm('Supprimer ce groupe ?')">
                                           <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
