<?php $__env->startSection('title', 'Accueil'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Ministères</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Ministères</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="<?php echo e(route('ministeres.create')); ?>" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                     <button onclick="exportTableToExcel('ministeres-table', 'ministeres.xlsx', {includeColumns: [0,1,2]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>

                    <table class="table datatable table-custom" id="ministeres-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Nom</th>
                                <th>Code</th>
                                <th>Actions</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $ministeres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ministere): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($ministere->id); ?></td>
                                    <td><?php echo e($ministere->nom); ?></td>
                                    <td><?php echo e($ministere->code); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('ministeres.edit', $ministere->id)); ?>" 
                                           class="btn-sm-status btn-sm-status-info">
                                           <i class="bi bi-pen"></i>
                                        </a>
                                        <a href="<?php echo e(route('ministeres.destroy', $ministere->id)); ?>" 
                                           class="btn-sm-status btn-sm-status-danger"
                                           onclick="return confirm('Supprimer ce ministère ?')">
                                           <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                    <td></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/ministeres/index.blade.php ENDPATH**/ ?>