<?php $__env->startSection('title', 'Prévisions'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h3>Tableau des prévisions</h3>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Prévisions</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
         
        	 <br/><button onclick="exportTableToExcel('previsions-table', 'prévisions.xlsx', {includeColumns: [0,1,2,3,4]})" 
        class="btn btn-success">
    Exporter en Excel
</button>
				 <table class="table datatable table-custom" id="previsions-table">
					<thead class="table-dark">
						<tr>
							<th>Activité</th>
							<th>Extrant</th>
							<th>Date prévisionnelle</th>
							<th>Taux prévisionnel (%)</th>
							<th>État d'évaluation</th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $previsions->groupBy('activite_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activiteId => $activitePrevisions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<?php
								$activite = $activitePrevisions->first()->activite;
								$extrantsGrouped = $activitePrevisions->groupBy('extrant_id');
							?>
							<?php $__currentLoopData = $extrantsGrouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrantId => $extrantPrevisions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php
									$extrant = $extrantPrevisions->first()->extrant;
								?>
								<?php $__currentLoopData = $extrantPrevisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php
										$today = now();
										$dateEval = \Carbon\Carbon::parse($p->dateevaluation);
										$etat = '';
										$style = '';
										$details = '';

										if ($dateEval->isFuture()) {
											$etat = 'À venir';
											$style = 'bg-blue';
										} else {
											if ($p->evaluations->isEmpty()) {
												$jours = $dateEval->diffInDays($today, false);
												$jours = (int) $jours;
												$etat = 'En retard';
												$details = "($jours jrs)";
												$style = 'bg-red';
											} else {
												$evaluation = $p->evaluations->first();
												if (!$evaluation->valide) {
													$etat = 'Évalué non validé';
													$style = 'bg-orange';
												} else {
													$etat = 'Évalué et validé';
													$style = 'bg-green';
												}
											}
										}
									?>
									<tr>
										
										<?php if($loop->first && $loop->parent->first): ?>
											<td rowspan="<?php echo e($extrantsGrouped->sum(fn($grp) => $grp->count())); ?>">
												<?php echo e($activite->nom); ?>

												<a href="<?php echo e(route('activites.planning', $activite->id)); ?>" class="btn btn-info btn-sm">
													<i class="bi bi-eye"></i>
												</a>
											</td>
										<?php endif; ?>

										
										<?php if($loop->first): ?>
											<td rowspan="<?php echo e($extrantPrevisions->count()); ?>">
												<?php echo e($extrant->nom); ?>

											</td>
										<?php endif; ?>

										
										<td><?php echo e($p->dateevaluation); ?></td>
										<td><?php echo e($p->niveaucible); ?></td>
										<td>
											<span class="badge <?php echo e($style); ?>">
												<?php echo e($etat); ?> <?php echo e($details); ?>

											</span>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>

          <!-- End Table -->
        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/previsionactivites/index.blade.php ENDPATH**/ ?>