<?php $__env->startSection('title', 'Accueil'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
      <h1>Actions</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Actions</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
 <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
            <?php
				$usergroupId = Auth::user()->usergroup_id;
			?>
			<?php if(!in_array($usergroupId , [3, 5, 6])): ?>
							  <h5 class="card-title"><a href="<?php echo e(route('actions.create')); ?>" class="btn btn-primary rounded-pill">
				<i class="bi bi-plus-circle"></i> Ajouter
			</a>
			</h5>
			<?php endif; ?>

 <br/><button onclick="exportTableToExcel('actions-table', 'actions.xlsx', {includeColumns: [0,1,2,3]})" 
        class="btn btn-success">
    Exporter en Excel
</button>
			
  <table class="table datatable table-custom" id="actions-table">
			
					<thead class="table-dark">
						<tr>
							<th>Code & Nom</th>
							<th>Programme</th>
							<th>Actif</th>
							<th>Ouvert</th>
							<th>Actions</th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($action->code); ?> : <?php echo e($action->nom); ?></td>
								<td><?php echo e($action->programme->nom ?? 'Non défini'); ?></td>

								
								<td>
									<?php if(in_array(Auth::user()->usergroup_id, [3,5,6])): ?>
										<button class="btn btn-sm-status <?php echo e($action->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
											<?php echo e($action->actif ? 'Oui' : 'Non'); ?>

										</button>
									<?php endif; ?>
									<?php if(in_array(Auth::user()->usergroup_id, [1,2,4])): ?>
										<a href="<?php echo e(route('actions.actif', $action->id)); ?>" 
										   class="btn btn-sm-status <?php echo e($action->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
											<?php echo e($action->actif ? 'Oui' : 'Non'); ?>

										</a>
									<?php endif; ?>
								</td>

								
								<td>
									<?php if(in_array(Auth::user()->usergroup_id, [3,5,6])): ?>
										<button class="btn btn-sm-status <?php echo e($action->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
											<?php echo e($action->ouvert ? 'Ouvert' : 'Fermé'); ?>

										</button>
									<?php endif; ?>
									<?php if(in_array(Auth::user()->usergroup_id, [1,2,4])): ?>
										<a href="<?php echo e(route('actions.ouvert', $action->id)); ?>" 
										   class="btn btn-sm-status <?php echo e($action->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
											<?php echo e($action->ouvert ? 'Ouvert' : 'Fermé'); ?>

										</a>
									<?php endif; ?>
								</td>

								
								<td>
									<a href="<?php echo e(route('actions.show', $action->id)); ?>" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
									
									<?php if(in_array(Auth::user()->usergroup_id, [1,2,4]) && ($action->ouvert || !$action->actif)): ?>
										<a href="<?php echo e(route('actions.edit', $action->id)); ?>" class="btn btn-warning btn-sm">
											<i class="bi bi-pen"></i>
										</a>
										<a href="<?php echo e(route('actions.destroy', $action->id)); ?>"
										   class="btn btn-danger btn-sm"
										   onclick="return confirm('Supprimer cette action ?')">
											<i class="bi bi-trash"></i>
										</a>
									<?php endif; ?>
								</td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>


              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/actions/index.blade.php ENDPATH**/ ?>