<?php

namespace App\Http\Controllers;

use App\Models\Action;
use App\Models\Activite;
use Illuminate\Http\Request;
use App\Models\Programme;

class ActionsController extends Controller
{
   
    public function index()
    {
		$actions = Action::with(['programme'])->orderBy('code')->get();
        return view('actions.index', compact('actions')); 
    }


 public function create($progid=null)
    {
		if(isset($progid)){
			$programme = Programme::select('ouvert', 'actif')->findOrFail($progid);
			if(!$programme->ouvert){
				return redirect()->back()->with('error', 'Impossible d\'ajouter des actions à un programme fermé');
			}
			if(!$programme->actif){
				return redirect()->back()->with('error', 'Impossible, demandez l\'activation du programme');
			}
		}
		$programmes = Programme::where('actif', true)->where('ouvert',true)->orderBy('code')->get();
        return view('actions.create', compact('programmes', 'progid'));
    }
  public function store(Request $request)
    {
        $request->validate([
            'programme_id' => 'required|exists:programmes,id',
            'code' => 'required|max:20|unique:actions,code',
            'nom' => 'required|max:100|unique:actions,nom',
        ]);

        Action::create($request->all());

        return redirect()->route('programmes.show', $request->programme_id)->with('success', 'Action ajoutée avec succès.');
		//return redirect()->back()->with('success', 'Action ajoutée avec succès.');
    }

    public function show($id)
    {
        $action = Action::with(['programme', 'structures', 'activites', 'resultats', 'structurearchives'])->findOrFail($id);
		//dd($action); die();
        return view('actions.show', compact('action'));
    }

    public function edit($id)
    {
        $action = Action::findOrFail($id);
        $programmes = Programme::all();
        return view('actions.edit', compact('action', 'programmes'));
    }

    public function update(Request $request, $id)
    {
        $action = Action::findOrFail($id);
        $request->validate([
            'programme_id' => 'required|exists:programmes,id',
            'code' => 'required|max:20|unique:actions,code,' . $id,
            'nom' => 'required|max:100|unique:actions,nom,' . $id,
        ]);

        $action->update($request->all());

        return redirect()->route('actions.index')->with('success', 'Action mise à jour avec succès.');
    }

    public function destroy($id)
    {
        $action = Action::with('activites', 'structures')->findOrFail($id);
		$progid = $action->programme_id;
		
		if($action->activites->isNotEmpty()){
			//dd('activités'); die();
			return redirect()->route('programmes.show', $progid)->with('error', 'Cette action contient des activités');
		}
		if($action->structures->isNotEmpty()){
			//dd('structures'); die();
			return redirect()->route('programmes.show', $progid)->with('error', 'Veuillez enlever les structures intervenant');
		}
		if($action->actif || $action->ouvert){
			//dd('actif ou ouvert'); die();
			return redirect()->route('programmes.show', $progid)->with('error', 'Assurez vous que l\'action et fermée et désactivée');
		}
		//dd($action); die();
		try {
			$action->resultats()->delete();
			$action->delete();
			return redirect()->route('programmes.show', $progid)->with('success', 'Action supprimée avec succès.');
		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
    }

    
    public function actif($id)
    {
		$action = Action::findOrFail($id);
		$progactif = Programme::select('actif')->findOrFail($action->programme_id);
		$out = 'Non effectué. Vérifiez que le programme est actif.';
		if($progactif->actif){
			$newstate = !$action->actif;
			$action->actif = !$action->actif;
			$action->save();
			if(!$newstate){
				$action->ouvert = $newstate;
				$action->save();
				Activite::where('action_id', $id)->update(['actif' => $newstate, 'ouvert' => $newstate]);
				//Activite::where('action_id', $id)->update(['ouvert' => $newstate]);
			}
			$out = 'Statut d’ouverture mis à jour.';
		}

        return back()->with('success', $out);
    }

    
    public function ouvert($id)
    {
        $action = Action::findOrFail($id);
		$progouvert = Programme::select('ouvert')->findOrFail($action->programme_id);
		$out = 'Non effectué. Vérifiez que le programme est ouvert.';
		if($progouvert->ouvert){
			$newstate = !$action->ouvert;
			if($newstate && !$action->actif){
				return redirect()->back()->with('success', 'Imposible, activez d\'abord l\'Action');
			}
			$action->ouvert = !$action->ouvert;
			$action->save();
			if(!$newstate){
				Activite::where('action_id', $id)->update(['ouvert' => $newstate]);
			}
			$out = 'Statut d’ouverture mis à jour.';
		}

        return back()->with('success', $out);
    }
}
