<?php

namespace App\Http\Controllers;

use App\Models\Activite;
use App\Models\Csd;
use App\Models\GroupeActivite;
use App\Models\Action;
use App\Models\Structure;
use Illuminate\Http\Request;

class ActivitesController extends Controller
{
    public function index()
    {
        $activites = Activite::with(['action', 'structureresponsable'])->orderBy('code')->get();
        return view('activites.index', compact('activites'));
    }

    public function create($actionid=null)
    {
		if(isset($actionid)){
			$action = Action::select('ouvert', 'actif')->findOrFail($actionid);
			if(!$action->ouvert){
				return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée');
			}
			if(!$action->actif){
				return redirect()->back()->with('error', 'Impossible, demandez l\'activation de l\'action');
			}
		}
		$structures = Structure::where('is_active', true)->get();
		$csds = Csd::orderBy('code')->get();
		$groupes = GroupeActivite::where('is_active', true)->orderBy('csd_id')->orderBy('code')->get();
		$actions = Action::where('actif',true)->where('ouvert',true)->orderBy('code')->get();
		
        return view('activites.create', compact('actions', 'structures', 'groupes', 'actionid', 'csds'));
    }

    public function store(Request $request)
    {
	//dd($request); die();
        $request->validate([
			'groupe_id' => 'required|integer',
            'code' => 'required',
            'nom' => 'required',
            'datedebut' => 'required|date',
            'datefin' => 'required|date|after_or_equal:datedebut',
            'montant' => 'required|numeric',
            'structure_id' => 'required|integer',
            'action_id' => 'required|integer'
	]);
		
		//$action = Action::select('ouvert', 'actif')->findOrFail($request->action_id);
		//if($action->ouvert && $action->actif){
			//Activite::create($request->all());
			//return redirect()->route('actions.show', $request->action_id)->with('success', 'Activité ajoutée avec succès.');
		//}
        //return redirect()->route('activites.index')->with('success', 'Activité créée avec succès.');
		//return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée');
   try {
            $action = Action::select('ouvert', 'actif')->findOrFail($request->action_id);

            if ($action->ouvert && $action->actif) {
                $data = new Activite($request->all());

                if ($data->save()) {
                    return redirect()->route('actions.show', $request->action_id)
                        ->with('success', 'Activité ajoutée avec succès.');
                } else {
                    return redirect()->back()->with('error', 'Échec de l’enregistrement de l’activité.');
                }
            }

            return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function show($id)
    {
	    dd("En cours"); die();
        $activite = Activite::with(['action', 'structureresponsable', 'groupeactivite', 'structurespartenaires', 'evaluations'])->findOrFail($id);
        //dd($activite); die();
		return view('activites.show', compact('activite'));
    }

    public function edit($id)
    {
        $activite = Activite::findOrFail($id);
        $actions = Action::all();
        $structures = Structure::where('is_active', true)->get();
		$groupes = GroupeActivite::all();

        return view('activites.edit', compact('activite', 'actions', 'structures', 'groupes'));
    }

    public function update(Request $request, $id)
    {
        $activite = Activite::findOrFail($id);
		$validated =$request->validate([
			'groupe_id' => 'required|integer',
            'code' => 'required',
            'nom' => 'required',
            'datedebut' => 'required|date',
            'datefin' => 'required|date|after_or_equal:datedebut',
            'montant' => 'required|numeric',
            'structure_id' => 'required|integer',
            'action_id' => 'required|integer'
        ]);
       // $activite->update($validated);

        //return redirect()->route('activites.index')->with('success', 'Activité mise à jour avec succès.');
        try {
            $activite = Activite::findOrFail($id);
            $activite->fill($validated);

            if ($activite->save()) {
                return redirect()->route('activites.index')->with('success', 'Activité mise à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour de l’activité.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function destroy($id)
    {
        //$activite = Activite::with('groupeactivite', 'structurespartenaires')->findOrFail($id);
		
		//$actionid = $activite->action_id;
		
      //  $activite->delete();
		
	//	return redirect()->route('actions.show', $actionid)->with('success', 'Activitée supprimée avec succès.');
        //return redirect()->route('activites.index')->with('success', 'Activité supprimée avec succès.');
         try {
            $activite = Activite::with('groupeactivite', 'structurespartenaires')->findOrFail($id);
            $actionid = $activite->action_id;

            if ($activite->delete()) {
                return redirect()->route('actions.show', $actionid)->with('success', 'Activité supprimée avec succès.');
            } else {
                return redirect()->route('actions.show', $actionid)->with('error', 'Échec de la suppression.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }


    public function actif($id)
    {
      //  $activite = Activite::findOrFail($id);
		//$actionactif = Action::select('actif')->findOrFail($activite->action_id);
		//$out = 'Non effectué. Vérifiez que l\'activité est active';
		//if($actionactif->actif){
			//$newstate = !$activite->actif;
			//if(!$newstate){
				//$activite->ouvert = $newstate;
			//}
			//$activite->actif = !$activite->actif;
			//$activite->save();
			//$out = 'État mis à jour avec succès.';
	//	}
 

 //       return redirect()->back()->with('success', $out);
 try {
            $activite = Activite::findOrFail($id);
            $actionactif = Action::select('actif')->findOrFail($activite->action_id);

            if ($actionactif->actif) {
                $activite->actif = !$activite->actif;
                if (!$activite->actif) {
                    $activite->ouvert = false;
                }

                if ($activite->save()) {
                    return redirect()->back()->with('success', 'État mis à jour avec succès.');
                } else {
                    return redirect()->back()->with('error', 'Échec de la mise à jour de l’état.');
                }
            }

            return redirect()->back()->with('error', 'Non effectué. Vérifiez que l\'activité est active.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    
    public function ouvert($id)
    {
       /* $activite = Activite::findOrFail($id);
		$actionouvert = Action::select('ouvert')->findOrFail($activite->action_id);
		$out = 'Non effectué. Vérifiez que l\'activité est ouverte';
		if($actionouvert->ouvert){
			$newstate = !$activite->ouvert;
			if($newstate && !$activite->actif){
				return redirect()->back()->with('success', 'Imposible, activez d\'abord l\'Activité');
			}
			$activite->ouvert = !$activite->ouvert;
			$activite->save();
			$out = 'État mis à jour avec succès.';
		}

        return redirect()->back()->with('success', 'État d’ouverture modifié.');*/
        try {
            $activite = Activite::findOrFail($id);
            $actionouvert = Action::select('ouvert')->findOrFail($activite->action_id);

            if ($actionouvert->ouvert) {
                $newstate = !$activite->ouvert;

                if ($newstate && !$activite->actif) {
                    return redirect()->back()->with('error', 'Impossible, activez d\'abord l’activité.');
                }

                $activite->ouvert = $newstate;

                if ($activite->save()) {
                    return redirect()->back()->with('success', 'État d’ouverture modifié avec succès.');
                } else {
                    return redirect()->back()->with('error', 'Échec de la modification de l’état.');
                }
            }

            return redirect()->back()->with('error', 'Non effectué. Vérifiez que l\'activité est ouverte.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
	
	public function getGroupesParCsd($id)
    {
        $groupes = GroupeActivite::where('csd_id', $id)
        ->where('is_active', true)->orderBy('code')
        ->get(['id', 'nom']);

    return response()->json($groupes);
    } 
}
