<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Evenement;
class LoginController extends Controller
{
    //
	// Afficher le formulaire de connexion
    public function showLoginForm()
    {
        return view('auth.login');
    }

    // Traitement du login
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required','email'],
            'password' => ['required'],
        ]);

        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
    Evenement::create([
            'utilisateur_id' => Auth::id(),
            'level' => 1,
            'details' => 'Connexion réussie',
        ]);       
     return redirect()->intended('dashboard');
       
        }
  Evenement::create([
        'utilisateur_id' => 1, 
        'level' => 2,
        'details' => 'Échec de connexion pour ' . $request->email,
    ]);
        return back()->withErrors([
            'email' => 'Identifiants invalides.',
        ]);
       
    }

    // Déconnexion
    public function logout(Request $request)
    {
       Evenement::create([
            'utilisateur_id' => Auth::id(),
            'level' => 1,
            'details' => 'Deconnexion',
        ]);
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        

        return redirect()->route('login');
    }
}
