<?php

namespace App\Http\Controllers;

use App\Models\Programme;
use App\Models\Action;
use App\Models\ResponsableProgramme;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProgrammesController extends Controller
{
    public function index()
    {
        $programmes = Programme::orderBy('code', 'asc')->get();
        return view('programmes.index', compact('programmes'));
    }

    public function create()
    {
        return view('programmes.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:2|unique:programmes,code',
            'nom' => 'required|string|max:200|unique:programmes,nom',
            'description' => 'nullable|string',
        ]);

        Programme::create($validated);

        return redirect()->route('programmes.index')->with('success', 'Programme ajouté avec succès.');
    }

    public function show($id)
    {
        /*if(!Session::has('utilisateur') and !Session::has('type')){
            return view('utilisateurs/login');
        }*/
		$programme = Programme::with('actions', 'user', 'responsables')->findOrFail($id);
		//dd($programme); die();
		$programme->refresh();
		
        return view('programmes.show', compact('programme'));
    }

    public function edit($id)
    {
        $programme = Programme::findOrFail($id);
        return view('programmes.edit', compact('programme'));
    }

    public function update(Request $request, $id)
    {
        $programme = Programme::findOrFail($id);

        $validated = $request->validate([
            'code' => 'required|string|max:2|unique:programmes,code,' . $programme->id,
            'nom' => 'required|string|max:100|unique:programmes,nom,' . $programme->id,
            'description' => 'nullable|string',
        ]);

        $programme->update($validated);

        return redirect()->route('programmes.index')->with('success', 'Programme mis à jour avec succès.');
    }

    public function destroy($id)
    {
		try {
			$programme = Programme::findOrFail($id);
			$programme->delete();
			return redirect()->route('programmes.index')->with('success', 'Programme supprimé avec succès.');
		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
    }

    
    public function fonctactif($id)
    {
        $programme = Programme::findOrFail($id);
		$newstate = !$programme->actif;
        $programme->actif = !$programme->actif;
        $programme->save();
		if(!$newstate){
			//Action::where('programme_id', $id)->update(['actif' => $newstate]);
			DB::statement('CALL update_programme_actif(?, ?)', [$id, $newstate]);
			$programme->ouvert = $newstate;
			$programme->save();
			//Action::where('programme_id', $id)->update(['ouvert' => $newstate]);
			DB::statement('CALL update_programme_ouvert(?, ?)', [$id, $newstate]);
		}
        //return redirect()->route('programmes.index')->with('success', 'État du programme mis à jour.');
		return redirect()->back()->with('success', 'État du programme mis à jour.');
    }
	
    public function fonctouvert($id)
    {
        $programme = Programme::findOrFail($id);
		$newstate = !$programme->ouvert;
		if($newstate && !$programme->actif){
			return redirect()->back()->with('success', 'Imposible, activez d\'abord le programme.');
		}
        $programme->ouvert = !$programme->ouvert;
        $programme->save();
		if(!$newstate){
			//Action::where('programme_id', $id)->update(['ouvert' => $newstate]);
			DB::statement('CALL update_programme_ouvert(?, ?)', [$id, $newstate]);
		}
        //return redirect()->route('programmes.index')->with('success', 'Statut d’ouverture du programme mis à jour.');
		return redirect()->back()->with('success', 'Statut d’ouverture du programme mis à jour.');
    }
	
	public function rpremove($id)
    {
        $programme = Programme::findOrFail($id);
		$programme->user_id = null;
        if($programme->save()){
			$resprog = ResponsableProgramme::where('programme_id', $id)->orderBy('id', 'desc')->first();
			$resprog->datefin = now();
			$resprog->save();
			
			$user = User::find($resprog->user_id);
			$user->is_rp = false;
			$user->save();
		}
        return redirect()->back()->with('success', 'Statut d’ouverture du programme mis à jour.');
    }
}

