<?php

namespace App\Http\Controllers;

use App\Models\StructureActivite;
use Illuminate\Http\Request;

class StructureActivitesController extends Controller
{
    public function index() {
	 return StructureActivite::all(); }
    public function show($id) {
	 return StructureActivite::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'structure_id' => 'required|integer',
        ]);
        return StructureActivite::create($data);
    }

    public function update(Request $request, $id)
    {
        $sa = StructureActivite::findOrFail($id);
        $data = $request->validate([
            'activite_id' => 'sometimes|integer',
            'structure_id' => 'sometimes|integer',
        ]);
        $sa->update($data);
        return $sa;
    }

    public function destroy($id) { 
	StructureActivite::findOrFail($id)->delete(); return response()->json(['message'=>'Structure Activité supprimée']); }
}
