<?php

namespace App\Http\Controllers;

use App\Models\Structure;
use App\Models\Ministere;
use App\Models\StructureAction;
use Illuminate\Http\Request;

class StructuresController extends Controller
{
    public function index()
    {
		$structures = Structure::with(['ministere'])->get();
		return view('structures.index', compact('structures'));
    }

    public function create()
    {
        $ministeres = Ministere::all();
        return view('structures.create', compact('ministeres'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:structures,code',
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
            'ministere_id' => 'required|exists:ministeres,id',
        ]);

        Structure::create($validated);

        return redirect()->route('structures.index')->with('success', 'Structure ajoutée avec succès.');
    }

public function edit($id = 0)
    {   $structure = Structure::find($id);
        $ministeres = Ministere::all();
        return view('structures.edit', compact('structure', 'ministeres'));
    }

 public function update(Request $request, $id =0)
    {
	$structure = Structure::findOrFail($id);
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:structures,code,' . $structure->id,
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
            'ministere_id' => 'required|exists:ministeres,id',
        ]);

        $structure->update($validated);

        return redirect()->route('structures.index')->with('success', 'Structure mise à jour avec succès.');
    }


    public function destroy($id)
    { $structure =Structure::findOrFail($id);

        $structure->delete();
        return redirect()->route('structures.index')->with('success', 'Structure supprimée avec succès.');
    }
	
	public function selecforaction($actionid, $actionstate)
    {
        //$users = User::with('usergroup')->get();
		if($actionstate == false){
			return redirect()->route('actions.show', $actionid)->with('error', 'L\'action doit être activée et ouverte aux modifications.');
		}
		$structures = Structure::with('ministere') // inclut les infos du ministère
		->whereDoesntHave('actions', function ($query) use ($actionid) {
			$query->where('actions.id', $actionid)
				  ->where('structure_action.is_active', true); // on cible la vraie colonne pivot
		})->get();

		//dd($structures,); die();
		return view('structures.addtoaction', compact('structures', 'actionid', 'actionstate'));
    }
	
}
