<?php

namespace App\Http\Controllers;

use App\Models\TypePartenaire;
use Illuminate\Http\Request;

class TypePartenairesController extends Controller
{
    public function index()
    {
        $typepartenaires = TypePartenaire::all();
        return view('typepartenaires.index', compact('typepartenaires'));
    }

    public function create()
    {
        return view('typepartenaires.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'type' => 'required|string|max:100|unique:typepartenaires,type',
            'description' => 'nullable|string',
        ]);

        TypePartenaire::create($validated);

        return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire ajouté avec succès.');
    }

   public function edit($id = 0)
    {
		$typepartenaire = TypePartenaire::find($id);
        return view('typepartenaires.edit', compact('typepartenaire'));
    }
   public function update(Request $request, $id)
    {
	$typePartenaire = TypePartenaire::findOrFail($id);
        $validated = $request->validate([
            'type' => 'required|string|max:100|unique:typepartenaires,type,' . $typePartenaire->id,
            'description' => 'nullable|string',
        ]);

        $typePartenaire->update($validated);

        return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire mis à jour avec succès.');
    }

    public function destroy($id)
    { $typePartenaire =TypePartenaire::findOrFail($id);

        $typePartenaire->delete();
        return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire supprimé avec succès.');
    }
}
