<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Evaluation extends Model
{
    use HasFactory;

    protected $table = 'evaluations';
    protected $primaryKey = 'id';

    protected $fillable = [
        'activite_id',
        'etape_id',
        'valide',
        'commentaire',
        'created_at',
        'updated_at',
        'previsionactivite_id',
    ];

    public $timestamps = false;

    // Relation avec Activite
    public function activite()
    {
        return $this->belongsTo(Activite::class, 'activite_id', 'id');
    }

    // Relation avec Etape
    public function etape()
    {
        return $this->belongsTo(Etape::class, 'etape_id', 'id');
    }

    // Relation avec PrevisionActivite
    public function prevision()
    {
        return $this->belongsTo(PrevisionActivite::class, 'previsionactivite_id', 'id');
    }
}
