<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResponsableProgramme extends Model
{
    use HasFactory;

    protected $table = 'responsableprogrammes';
    protected $primaryKey = 'id';

    protected $fillable = [
        'programme_id',
        'user_id',
        'datedebut',
        'datefin',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    // Relation avec Programme
    public function programme()
    {
        return $this->belongsTo(Programme::class, 'programme_id', 'id');
    }

    // Relation avec User
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
