@extends('layouts.app')
@section('title', 'Action')

@section('content')
 <div class="pagetitle">
    <h1>Détails Action</h1>
    <nav>
		<ol class="breadcrumb">
		    <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
		    <li class="breadcrumb-item"><a href="{{ route('programmes.show', $action->programme_id) }}">Détail programme</a></li>
		    <li class="breadcrumb-item active">Détails action</li>
		</ol>
    </nav>
</div><!-- End Page Title -->
<section class="section">
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h5 class="card-title">Détails de l'action: <span id="details"></h5>
					@if(Session::has('status'))
					<div class="col-md-3" style="margin-left:15%">
						<div class="card card-success shadow-sm">
							<div class="card-header">
							    <h3 class="card-title">Correct</h3>

							    <div class="card-tools">
									<button type="button" class="btn btn-tool" data-card-widget="remove">
									    <i class="fas fa-times"></i>
									</button>
							    </div>
							</div>
							<div class="card-body">
								{{Session::get('status')}}
							</div>
						</div>
					</div>
					@endif
					<div class="card-body">
						<h2>Détails : <strong> {{ $action->nom }}</strong> </h2>
						<hr>
						<div class="row">
							<a href="{{--URL::to('pdf/'.$action->id)--}}" class="nav-link">
							<!--<button type="button" class="btn btn-block btn-success btn-sm"><i class="nav-icon fas fa-print"></i>Imprimer</button> -->
							</a>
						</div>
						<div class="row">
							<div class="col-md-10">
								<div class="callout callout-primary">
									<h5><b><u>Informations générales</u></b></h5>
									<ul class="list-group list-group-unbordered mb-3">
										<li class="list-group-item">
											<b>Code  : </b> <a class="float-right">  {{$action->code}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Intitulé  : </b> <a class="float-right">  {{$action->nom}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Détails  : </b><br> <a class="float-right">  {{$action->description}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Action activé : </b> <a class="float-right">
											@if(Auth::user()->usergroup_id == 4)
												<button class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
													{{ $action->actif ? 'OUI' : 'NON' }}
												</button>
											@else
												 <a href="{{ route('actions.actif', $action->id) }}" 
													class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}">
													{{ $action->actif ? 'OUI' : 'NON' }}
												</a>
											@endif
											</a><br>
										</li>
										<li class="list-group-item">
											<b> Ouvert (en élaboration/revu) : </b> <a class="float-right">
											@if(Auth::user()->usergroup_id == 4)
												<button class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
													{{ $action->ouvert ? 'OUI' : 'NON' }}
												</button>
											@else
												 <a href="{{ route('actions.ouvert', $action->id) }}" 
													class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}">
													{{ $action->ouvert ? 'OUI' : 'NON' }}
												</a>
											@endif
											</a><br>
										</li>
									</ul>
								</div>
							</div>
						</div><hr><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Résultats de l'actions</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Libellé</th>
											<th>Description</th>
											<th>Action</th>
										</tr>
									</thead>
									<tbody>
										@if($action->ouvert && $action->actif)
											<h6 class="card-title"><a href="{{ route('resultats.create', ['actionid' => $action->id]) }}" class="btn btn-primary rounded-pill"><i class="bi bi-plus-circle"></i> Ajouter un  résultat</a></h6>
										@endif
										@if (!is_null($action->resultats))
											@foreach ($action->resultats as $resultat)
											<tr>
												<td>{{ $resultat->nom }} </td>
												<td>{{ $resultat->description  }}</td>
												<td><a href="{{ route('resultats.destroy', $resultat->id)}}"> 
												<i class="bi bi-danger" onclick="return confirm('Enlever ce RP?')">
													<i class="bi bi-trash"></i>
												</i> </a></td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Liste des activités</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Code</th>
											<th>Libellé</th>
											<th>Groupe d'activité</th>
											<th>Responsable</th>
											<th>Actif</th>
											<th>Ouvert</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<h6 class="card-title">
											@if($action->ouvert && $action->actif)
												<a href="{{ route('activites.create', $action->id) }}" class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une étape
												</a>
											@endif
										</h6>
										@if (!is_null($action->activites))
											@foreach ($action->activites as $activite)
											<tr>
												<td>{{ $activite->code }} </td>
												<td>{{ $activite->nom  }}</td>
												<td>{{ $activite->groupeactivite->nom ?? '-' }}</td>
												<td>{{ $activite->structureresponsable->nom ?? '-' }}</td>
												<td><a href="{{ route('activites.actif', $activite->id) }}" 
													class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}">
													{{ $activite->actif ? 'Oui' : 'Non' }}
												</a></td>
												<td><a href="{{ route('activites.ouvert', $activite->id) }}" 
													class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}">
													{{ $action->ouvert ? 'Ouvert' : 'Fermé' }}
												</a></td>
												<td>
													<a href="{{ route('activites.show', $activite->id) }}" class="btn btn-info"><i class="bi bi-eye"></i></a>
													<a href="{{ route('activites.edit', $activite->id) }}" class="btn btn-warning"><i class="bi bi-pen"></i></a>
													<a href="{{ route('activites.destroy', $activite->id) }}" class="btn btn-danger" onclick="return confirm('Supprimer cette activite ?')"><i class="bi bi-trash"></i></a>
												</td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div><hr>
                        <div class="row">
							<div class="callout callout-primary">
								<h5><b><u><b>Liste des structures intervenant</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Structure</th>
											<th>Ministère</th>
											<th>Du : </th>
											<th>Au : </th>
											<th></th>
										</tr>
									</thead>
									<tbody>
										@php
											$canAddStructure = $action->ouvert && $action->actif;
										@endphp
										@if($canAddStructure)
											<h6 class="card-title">
												<a href="{{ route('structures.selecforaction', ['actionid' => $action->id, 'actionstate' => $canAddStructure]) }}" 
												   class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une structure
												</a>
											</h6>
										@endif
										@if (!is_null($action->structures))
											@foreach ($action->structures as $structure)
											<tr>
												<td>{{ $structure->nom }} ({{ $structure->code }})</td>
												<td>{{ $structure->ministere->nom }} ({{ $structure->ministere->code }})</td>
												<td>{{ $structure->pivot->datedebut }}</td>
												<td>{{ $structure->pivot->datefin?? 'En cours' }}</td>
												<td> <a href="{{ route('structureactions.detach', $structure->pivot->id) }}" class="btn btn-info">X</a>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div>
						<div class="callout callout-primary">
								<h5><b><u><b>Historique des anciens intervenants</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Structure</th>
											<th>Ministère</th>
											<th>Du : </th>
											<th>Au : </th>
										</tr>
									</thead>
									<tbody>
										@if (!is_null($action->structurearchives))
											@foreach ($action->structurearchives as $structureold)
											<tr>
												<td>{{ $structureold->nom }} ({{ $structureold->code }})</td>
												<td>{{ $structureold->ministere->nom }} ({{ $structureold->ministere->code }})</td>
												<td>{{ $structureold->pivot->datedebut }}</td>
												<td>{{ $structureold->pivot->datefin }}</td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
@endsection


