<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ActionsController;
use App\Http\Controllers\ProgrammesController;
use App\Http\Controllers\ResponsablesProgrammesController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\UsergroupsController;
use App\Http\Controllers\PointfocalsController;
use App\Http\Controllers\StructuresController;
use App\Http\Controllers\MinisteresController;
use App\Http\Controllers\ActivitesController;
use App\Http\Controllers\EvaluationsController;
use App\Http\Controllers\EtapesController;
use App\Http\Controllers\ModeleActivitesController;
use App\Http\Controllers\CsdsController;
use App\Http\Controllers\GroupeActivitesController;
use App\Http\Controllers\PrevisionActivitesController;
use App\Http\Controllers\StructureActivitesController;
use App\Http\Controllers\ExtrantsController;
use App\Http\Controllers\FinancementActivitesController;
use App\Http\Controllers\PartenairesController;
use App\Http\Controllers\TypePartenairesController;
use App\Http\Controllers\EvaluationStructuresController;
use App\Http\Controllers\ResponsableStructuresController;
use App\Http\Controllers\StructureActionsController;
use App\Http\Controllers\ResultatsController;
use App\Http\Controllers\IndicateursController;
use App\Http\Controllers\EvenementsController;

Route::get('/', function () {
    return redirect()->route('login');
});

// Login
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login'])->name('login.submit');

// Déconnexion
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Dashboard (protégé par auth)
Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware('auth')
    ->name('dashboard');


//Route::get('/', function () {
  //  return view('welcome');
//});

Route::middleware(['auth', 'check.admin.access'])->group(function () {

	// Actions	
	Route::get('actions', [ActionsController::class, 'index'])->name('actions.index');
	Route::post('actions/enregistrement', [ActionsController::class, 'store'])->name('actions.store');
	Route::post('actions/update/{id}', [ActionsController::class, 'update'])->name('actions.update');
	Route::get('actions/suppression/{id}', [ActionsController::class, 'destroy'])->name('actions.destroy');
	Route::get('actions/ajout/{progid?}', [ActionsController::class, 'create'])->name('actions.create');
	Route::get('actions/{id}/edit', [ActionsController::class, 'edit'])->name('actions.edit');
	Route::get('actions/{id}/actif', [ActionsController::class, 'actif'])->name('actions.actif');
	Route::get('actions/{id}/ouvert', [ActionsController::class, 'ouvert'])->name('actions.ouvert');
	Route::get('actions/{id}/show', [ActionsController::class, 'show'])->name('actions.show');

	// Programmes
	Route::get('programmes', [ProgrammesController::class, 'index'])->name('programmes.index');
	Route::post('programmes/enregistrement', [ProgrammesController::class, 'store'])->name('programmes.store');
	Route::post('programmes/update/{id}', [ProgrammesController::class, 'update'])->name('programmes.update');
	Route::get('programmes/suppression/{id}', [ProgrammesController::class, 'destroy'])->name('programmes.destroy');
	Route::get('programmes/ajout', [ProgrammesController::class, 'create'])->name('programmes.create');
	Route::get('programmes/{id}/edit', [ProgrammesController::class, 'edit'])->name('programmes.edit');
	Route::get('programmes/{id}/fonctactif', [ProgrammesController::class, 'fonctactif'])->name('programmes.fonctactif');
	Route::get('programmes/{id}/fonctouvert', [ProgrammesController::class, 'fonctouvert'])->name('programmes.fonctouvert');
	Route::get('programmes/{id}/show', [ProgrammesController::class, 'show'])->name('programmes.show');
	Route::get('programmes/{id}/rpremove', [ProgrammesController::class, 'rpremove'])->name('programmes.rpremove');

	// ResponsableProgrammes
	Route::get('responsableprogrammes', [ResponsableProgrammesController::class, 'index'])->name('responsableprogrammes.index');
	Route::post('responsableprogrammes/enregistrement', [ResponsableProgrammesController::class, 'store'])->name('responsableprogrammes.store');
	Route::post('responsableprogrammes/update', [ResponsableProgrammesController::class, 'update'])->name('responsableprogrammes.update');
	Route::get('responsableprogrammes/suppression/{id}', [ResponsableProgrammesController::class, 'destroy'])->name('responsableprogrammes.destroy');

	// Users

	Route::get('users', [UsersController::class, 'index'])->name('users.index');
	Route::post('users/enregistrement', [UsersController::class, 'store'])->name('users.store');
	Route::post('users/update/{id}', [UsersController::class, 'update'])->name('users.update');
	Route::get('users/suppression/{id}', [UsersController::class, 'destroy'])->name('users.destroy');
	Route::get('users/ajout', [UsersController::class, 'create'])->name('users.create');
	Route::get('users/{id}/edit', [UsersController::class, 'edit'])->name('users.edit');
	Route::get('users/{id}/actif', [UsersController::class, 'actif'])->name('users.actif');
	Route::get('users/{id}/show', [UsersController::class, 'show'])->name('users.show');
	Route::get('users/{level}/{levelid}/{userid}/rpadd', [UsersController::class, 'rpadd'])->name('users.rpadd');
	Route::get('users/{level}/{id}/rpcreate', [UsersController::class, 'rpcreate'])->name('users.rpcreate');
	
	// UserGroups

	Route::get('usergroups', [UsergroupsController::class, 'index'])->name('usergroups.index');
	Route::post('usergroups/enregistrement', [UsergroupsController::class, 'store'])->name('usergroups.store');
	Route::post('usergroups/update/{id}', [UsergroupsController::class, 'update'])->name('usergroups.update');
	Route::get('usergroups/suppression/{id}', [UsergroupsController::class, 'destroy'])->name('usergroups.destroy');
	Route::get('usergroups/ajout', [UsergroupsController::class, 'create'])->name('usergroups.create');
	Route::get('usergroups/{id}/edit', [UsergroupsController::class, 'edit'])->name('usergroups.edit');

	// PointFocals
	Route::get('pointfocals', [PointfocalsController::class, 'index'])->name('pointfocals.index');
	Route::post('pointfocals/enregistrement', [PointfocalsController::class, 'store'])->name('pointfocals.store');
	Route::post('pointfocals/update', [PointfocalsController::class, 'update'])->name('pointfocals.update');
	Route::get('pointfocals/suppression/{id}', [PointfocalsController::class, 'destroy'])->name('pointfocals.destroy');

	// Structures
	Route::get('structures', [StructuresController::class, 'index'])->name('structures.index');
	Route::post('structures/enregistrement', [StructuresController::class, 'store'])->name('structures.store');
	Route::post('structures/update/{id}', [StructuresController::class, 'update'])->name('structures.update');
	Route::get('structures/suppression/{id}', [StructuresController::class, 'destroy'])->name('structures.destroy');
	Route::get('strutures/ajout', [StructuresController::class, 'create'])->name('structures.create');
	Route::get('strutures/{id}/edit', [StructuresController::class, 'edit'])->name('structures.edit');
	Route::get('strutures/{actionid}/{actionstate}/selecforaction', [StructuresController::class, 'selecforaction'])->name('structures.selecforaction');

	// Ministeres
	Route::get('ministeres', [MinisteresController::class, 'index'])->name('ministeres.index');
	Route::post('ministeres/enregistrement', [MinisteresController::class, 'store'])->name('ministeres.store');
	Route::post('ministeres/update/{id}', [MinisteresController::class, 'update'])->name('ministeres.update');
	Route::get('ministeres/suppression/{id}', [MinisteresController::class, 'destroy'])->name('ministeres.destroy');
	Route::get('ministeres/ajout', [MinisteresController::class, 'create'])->name('ministeres.create');
	Route::get('ministeres/{id}/edit', [MinisteresController::class, 'edit'])->name('ministeres.edit');
	// Activites
	Route::get('activites', [ActivitesController::class, 'index'])->name('activites.index');
	Route::post('activites/enregistrement', [ActivitesController::class, 'store'])->name('activites.store');
	Route::post('activites/update/{id}', [ActivitesController::class, 'update'])->name('activites.update');
	Route::get('activites/suppression/{id}', [ActivitesController::class, 'destroy'])->name('activites.destroy');
	Route::get('activites/ajout/{actionid?}', [ActivitesController::class, 'create'])->name('activites.create');
	Route::get('activites/{id}/edit', [ActivitesController::class, 'edit'])->name('activites.edit');
	Route::get('activites/{id}/fonctactif', [ActivitesController::class, 'actif'])->name('activites.actif');
	Route::get('activites/{id}/fonctouvert', [ActivitesController::class, 'ouvert'])->name('activites.ouvert');
	Route::get('activites/{id}/show', [ActivitesController::class, 'show'])->name('activites.show');
	Route::get('/activites/groupes/{id}', [App\Http\Controllers\ActivitesController::class, 'getGroupesParCsd'])->name('activites.groupes');


	// Evaluations
	Route::get('evaluations', [EvaluationsController::class, 'index'])->name('evaluations.index');
	Route::post('evaluations/enregistrement', [EvaluationsController::class, 'store'])->name('evaluations.store');
	Route::post('evaluations/update', [EvaluationsController::class, 'update'])->name('evaluations.update');
	Route::get('evaluations/suppression/{id}', [EvaluationsController::class, 'destroy'])->name('evaluations.destroy');

	// Etapes
	Route::get('etapes', [EtapesController::class, 'index'])->name('etapes.index');
	Route::get('etapes/ajout/{modelactiviteid}', [EtapesController::class, 'create'])->name('etapes.create');
	Route::post('etapes/enregistrement', [EtapesController::class, 'store'])->name('etapes.store');
	Route::post('etapes/update/{id}', [EtapesController::class, 'update'])->name('etapes.update');
	Route::get('etapes/suppression/{id}', [EtapesController::class, 'destroy'])->name('etapes.destroy');
	Route::get('etapes/{id}/edit', [EtapesController::class, 'edit'])->name('etapes.edit');

	// ModeleActivites
	Route::get('modeleactivites', [ModeleActivitesController::class, 'index'])->name('modeleactivites.index');
	Route::get('modeleactivites/ajout', [ModeleActivitesController::class, 'create'])->name('modeleactivites.create');
	Route::post('modeleactivites/enregistrement', [ModeleActivitesController::class, 'store'])->name('modeleactivites.store');
	Route::post('modeleactivites/update/{id}', [ModeleActivitesController::class, 'update'])->name('modeleactivites.update');
	Route::get('modeleactivites/suppression/{id}', [ModeleActivitesController::class, 'destroy'])->name('modeleactivites.destroy');
	Route::get('modeleactivites/{id}/edit', [ModeleActivitesController::class, 'edit'])->name('modeleactivites.edit');
	Route::get('modeleactivites/{id}/fonctactif', [ModeleActivitesController::class, 'actif'])->name('modeleactivites.actif');
	Route::get('modeleactivites/{id}/show', [ModeleActivitesController::class, 'show'])->name('modeleactivites.show');

	// CSDS
	Route::get('csds', [CsdsController::class, 'index'])->name('csds.index');
	Route::post('csds/enregistrement', [CsdsController::class, 'store'])->name('csds.store');
	Route::post('csds/update/{id}', [CsdsController::class, 'update'])->name('csds.update');
	Route::get('csds/suppression/{id}', [CsdsController::class, 'destroy'])->name('csds.destroy');
	Route::get('csds/ajout', [CsdsController::class, 'create'])->name('csds.create');
	Route::get('csds/{id}/edit', [CsdsController::class, 'edit'])->name('csds.edit');
	// GroupeActivites
	Route::get('groupeactivites', [GroupeActivitesController::class, 'index'])->name('groupeactivites.index');
	Route::post('groupeactivites/enregistrement', [GroupeActivitesController::class, 'store'])->name('groupeactivites.store');
	Route::post('groupeactivites/update/{id}', [GroupeActivitesController::class, 'update'])->name('groupeactivites.update');
	Route::get('groupeactivites/suppression/{id}', [GroupeActivitesController::class, 'destroy'])->name('groupeactivites.destroy');
	Route::get('groupeactivites/ajout', [GroupeActivitesController::class, 'create'])->name('groupeactivites.create');
	Route::get('groupeactivites/{id}/edit', [GroupeActivitesController::class, 'edit'])->name('groupeactivites.edit');
	Route::get('groupeactivites/{id}/fonctactif', [GroupeActivitesController::class, 'actif'])->name('groupeactivites.actif');
	Route::get('groupeactivites/{id}/show', [GroupeActivitesController::class, 'show'])->name('groupeactivites.show');
	
	// PrevisionActivites
	Route::get('previsionactivites', [PrevisionActivitesController::class, 'index'])->name('previsionactivites.index');
	Route::post('previsionactivites/enregistrement', [PrevisionActivitesController::class, 'store'])->name('previsionactivites.store');
	Route::post('previsionactivites/update', [PrevisionActivitesController::class, 'update'])->name('previsionactivites.update');
	Route::get('previsionactivites/suppression/{id}', [PrevisionActivitesController::class, 'destroy'])->name('previsionactivites.destroy');

	// StructureActivite
	Route::get('structureactivites', [StructureActivitesController::class, 'index'])->name('structureactivites.index');
	Route::post('structureactivites/enregistrement', [StructureActivitesController::class, 'store'])->name('structureactivites.store');
	Route::post('structureactivites/update', [StructureActivitesController::class, 'update'])->name('structureactivites.update');
	Route::get('structureactivites/suppression/{id}', [StructureActivitesController::class, 'destroy'])->name('structureactivites.destroy');

	// Extrants
	Route::get('extrants', [ExtrantsController::class, 'index'])->name('extrants.index');
	Route::post('extrants/enregistrement', [ExtrantsController::class, 'store'])->name('extrants.store');
	Route::post('extrants/update', [ExtrantsController::class, 'update'])->name('extrants.update');
	Route::get('extrants/suppression/{id}', [ExtrantsController::class, 'destroy'])->name('extrants.destroy');

	// FinancementActivites
	Route::get('financementactivites', [FinancementsActiviteController::class, 'index'])->name('financementactivites.index');
	Route::post('financementactivites/enregistrement', [FinancementsActiviteController::class, 'store'])->name('financementactivites.store');
	Route::post('financementactivites/update', [FinancementsActiviteController::class, 'update'])->name('financementactivites.update');
	Route::get('financementactivites/suppression/{id}', [FinancementsActiviteController::class, 'destroy'])->name('financementactivites.destroy');

	// Partenaires
	Route::get('partenaires', [PartenairesController::class, 'index'])->name('partenaires.index');
	Route::post('partenaires/enregistrement', [PartenairesController::class, 'store'])->name('partenaires.store');
	Route::post('partenaires/update/{id}', [PartenairesController::class, 'update'])->name('partenaires.update');
	Route::get('partenaires/suppression/{id}', [PartenairesController::class, 'destroy'])->name('partenaires.destroy');
	Route::get('partenaires/ajout', [PartenairesController::class, 'create'])->name('partenaires.create');
	Route::get('partenaires/{id}/edit', [PartenairesController::class, 'edit'])->name('partenaires.edit');

	// TypePartenaires
	Route::get('typepartenaires', [TypePartenairesController::class, 'index'])->name('typepartenaires.index');
	Route::post('typepartenaires/enregistrement', [TypePartenairesController::class, 'store'])->name('typepartenaires.store');
	Route::post('typepartenaires/update/{id}', [TypePartenairesController::class, 'update'])->name('typepartenaires.update');
	Route::get('typepartenaires/suppression/{id}', [TypePartenairesController::class, 'destroy'])->name('typepartenaires.destroy');
	Route::get('typepartenaires/ajout', [TypePartenairesController::class, 'create'])->name('typepartenaires.create');
	Route::get('typepartenaires/{id}/edit', [TypePartenairesController::class, 'edit'])->name('typepartenaires.edit');

	// EvaluationStructures
	Route::get('evaluationstructures', [EvaluationStructuresController::class, 'index'])->name('evaluationstructures.index');
	Route::post('evaluationstructures/enregistrement', [EvaluationStructuresController::class, 'store'])->name('evaluationstructures.store');
	Route::post('evaluationstructures/update', [EvaluationStructuresController::class, 'update'])->name('evaluationstructures.update');
	Route::get('evaluationstructures/suppression/{id}', [EvaluationStructuresController::class, 'destroy'])->name('evaluationstructures.destroy');

	// ResponsableStructures
	Route::get('responsablestructures', [ResponsableStructuresController::class, 'index'])->name('responsablestructures.index');
	Route::post('responsablestructures/enregistrement', [ResponsableStructuresController::class, 'store'])->name('responsablestructures.store');
	Route::post('responsablestructures/update', [ResponsableStructuresController::class, 'update'])->name('responsablestructures.update');
	Route::get('responsablestructures/suppression/{id}', [ResponsableStructuresController::class, 'destroy'])->name('responsablestructures.destroy');

	// StructureAction
	//Route::get('structureactions', [StructureActionsController::class, 'index'])->name('structureactions.index');
	Route::get('structureactions/{structureid}/{actionid}/{actionstate}/ajouter', [StructureActionsController::class, 'attach'])->name('structureactions.attach');
	//Route::post('structureactions/update', [StructureActionsController::class, 'update'])->name('structureactions.update');
	Route::get('structureactions/enlever/{id}', [StructureActionsController::class, 'detach'])->name('structureactions.detach');

	// Resultats
	Route::get('resultats', [ResultatsController::class, 'index'])->name('resultats.index');
	Route::get('resultats/ajout/{actionid?}', [ResultatsController::class, 'create'])->name('resultats.create');
	Route::post('resultats/enregistrement', [ResultatsController::class, 'store'])->name('resultats.store');
	Route::post('resultats/update', [ResultatsController::class, 'update'])->name('resultats.update');
	Route::get('resultats/suppression/{id}', [ResultatsController::class, 'destroy'])->name('resultats.destroy');

	// Evenements

	Route::get('evenements', [EvenementsController::class, 'index'])->name('evenements.index');


	// Indicateurs
	Route::get('indicateurs', [IndicateursController::class, 'index'])->name('indicateurs.index');
	Route::get('indicateurs/{id}/show', [IndicateursController::class, 'show'])->name('indicateurs.show');

});
