<?php $__env->startSection('title', 'Ministère'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-body">
    <h5 class="card-title">Modifier la structure</h5>

    <form method="POST" action="<?php echo e(route('structures.update', $structure->id)); ?>">
      <?php echo csrf_field(); ?>
      <?php echo method_field('POST'); ?>

      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control" value="<?php echo e(old('code', $structure->code)); ?>" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Nom</label>
          <input type="text" name="nom" class="form-control" value="<?php echo e(old('nom', $structure->nom)); ?>" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Ministère</label>
          <select name="ministere_id" class="form-select" required>
            <option value="">Sélectionner...</option>
            <?php $__currentLoopData = $ministeres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($m->id); ?>" <?php echo e(old('ministere_id', $structure->ministere_id) == $m->id ? 'selected' : ''); ?>>
                <?php echo e($m->nom); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="description" class="form-control"><?php echo e(old('description', $structure->description)); ?></textarea>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-primary">Mettre à jour</button>
          <a href="<?php echo e(route('structures.index')); ?>" class="btn btn-secondary">Annuler</a>
        </div>
      </div>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\phaso\resources\views/structures/edit.blade.php ENDPATH**/ ?>