<?php $__env->startSection('title', 'Modifier une Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Modification d'une Activité</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item">Activités</li>
      <li class="breadcrumb-item active">Modifier</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Modifier l’activité : <strong><?php echo e($activite->nom); ?></strong></h5>

          <form method="POST" action="<?php echo e(route('activites.update', $activite->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>
            <div class="row g-3">
			  <div class="col-md-6">
                <label class="form-label"><b>Nature d'activité</b></label>
                <select name="modele_id" class="form-control">
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $modeles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($m->id); ?>" <?php echo e($m->id == $activite->modele_id ? 'selected' : ''); ?>>
                      <?php echo e($m->nom); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
			</div>
			<div class="row g-3">
              <div class="col-md-3">
                <label class="form-label"><b>Code</b></label>
                <input type="text" name="code" class="form-control" value="<?php echo e(old('code', $activite->code)); ?>" required>
              </div>

              <div class="col-md-9">
                <label class="form-label"><b>Nom</b></label>
                <input type="text" name="nom" class="form-control" value="<?php echo e(old('nom', $activite->nom)); ?>" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date début</b></label>
                <input type="date" name="datedebut" class="form-control" value="<?php echo e(old('datedebut', $activite->datedebut)); ?>" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date fin</b></label>
                <input type="date" name="datefin" class="form-control" value="<?php echo e(old('datefin', $activite->datefin)); ?>" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Montant</b></label>
                <input type="number" step="0.001" name="montant" class="form-control" value="<?php echo e(old('montant', $activite->montant)); ?>" required>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Structure responsable</b></label>
                <select name="structure_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($s->id); ?>" <?php echo e($s->id == $activite->structure_id ? 'selected' : ''); ?>>
                      <?php echo e($s->nom); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Action</b></label>
                <select name="action_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($a->id); ?>" <?php echo e($a->id == $activite->action_id ? 'selected' : ''); ?>>
                      <?php echo e($a->nom); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
<?php
    $usergroupId = Auth::user()->usergroup_id;
?>
<?php if($usergroupId != 3): ?>
	   <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Mettre à jour</button>
<button type="reset" class="btn btn-secondary">Réinitialiser</button>
              </div>
<?php endif; ?>
           

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\phaso\resources\views/activites/edit.blade.php ENDPATH**/ ?>