<?php $__env->startSection('title', 'Activités'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Liste des Activités</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Activités</li>
    </ol>
  </nav>
</div>
<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">Toutes les activités</h5>
      <?php
    $usergroupId = Auth::user()->usergroup_id;
?>
<?php if($usergroupId != 3 && $usergroupId != 4): ?>
	 <a href="<?php echo e(route('activites.create')); ?>" class="btn btn-primary mb-3">Activité</a>
<?php endif; ?>
     

<table class="table datatable">
        <thead>
          <tr>
            
            <th>Code & Nom</th>
		<th>Groupe</th>
            <th>Action</th>
			<th>Responsable</th>
			<th>Montant</th>
            <th>Actif</th>
            <th>Ouvert</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            
            <td><?php echo e($a->code); ?>:<?php echo e($a->nom); ?></td>
          
            <td><?php echo e($a->groupeactivite->nom ?? '-'); ?></td>
			<td><?php echo e($a->action->nom ?? '-'); ?></td>
			<td><?php echo e($a->structureresponsable->nom ?? '-'); ?></td>
                        <td><?php echo e($a->montant ? number_format($a->montant, 0, '', ' ') : '-'); ?></td>
            <td>
             <?php if(Auth::user()->usergroup_id == 4): ?>
				<button class="btn btn-sm <?php echo e($a->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
				<?php echo e($a->actif ? 'Oui' : 'Non'); ?>

				</button>
			<?php else: ?>
				<a href="<?php echo e(route('activites.actif', $a->id)); ?>" 
					class="btn btn-sm <?php echo e($a->actif ? 'btn-success' : 'btn-secondary'); ?>">
					<?php echo e($a->actif ? 'Oui' : 'Non'); ?>

				</a>
            <?php endif; ?>  
            </td>
            <td>
                 <?php if(Auth::user()->usergroup_id == 4): ?>
        <button class="btn btn-sm <?php echo e($a->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
            <?php echo e($a->ouvert ? 'Ouvert' : 'Fermé'); ?>

        </button>
    <?php else: ?>
				<a href="<?php echo e(route('activites.ouvert', $a->id)); ?>" 
               class="btn btn-sm <?php echo e($a->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
              <?php echo e($a->ouvert ? 'Ouvert' : 'Fermé'); ?>

            </a>
        <?php endif; ?>       
            </td>
            <td>
			 <a href="<?php echo e(route('activites.show', $a->id)); ?>" class="btn btn-info"><i class="bi bi-eye"></i></a>
          <a href="<?php echo e(route('activites.edit', $a->id)); ?>" class="btn btn-warning">
            <i class="bi bi-pen"></i>
          </a>
          <?php if($usergroupId != 3 && $usergroupId != 4): ?>
          <a href="<?php echo e(route('activites.destroy', $a->id)); ?>"
   class="btn btn-danger"
   onclick="return confirm('Supprimer cette activité ?')">
   <i class="bi bi-trash"></i>
</a>
	
<?php endif; ?>

             
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/index.blade.php ENDPATH**/ ?>