<?php

namespace App\Http\Controllers;

use App\Models\Csd;
use Illuminate\Http\Request;

class CsdsController extends Controller
{
    public function index()
    {
        $csds = Csd::orderBy('code')->get();
        return view('csds.index', compact('csds'));
    }

    public function create()
    {
        return view('csds.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:csds,code',
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
        ]);

        Csd::create($validated);

        return redirect()->route('csds.index')->with('success', 'CSD ajouté avec succès.');
    }

 public function edit($id)
    {
        $csd = Csd::findOrFail($id);
        return view('csds.edit', compact('csd'));
    }
public function update(Request $request, $id)
    {
        $csd = Csd::findOrFail($id);

        $validated = $request->validate([
            'code' => 'required|string|max:50|unique:csds,code,' . $csd->id,
            'nom' => 'required|string|max:150',
            'description' => 'nullable|string',
        ]);

        $csd->update($validated);

        return redirect()->route('csds.index')->with('success', 'CSD modifié avec succès.');
    }

    public function destroy($id)
    {
        $csd = Csd::findOrFail($id);
        $csd->delete();

        return redirect()->route('csds.index')->with('success', 'CSD supprimé avec succès.');
    }
}
