<?php

namespace App\Http\Controllers;

use App\Models\ModeleActivite;
use App\Models\GroupeActivite;
use App\Models\Activite;
use Illuminate\Http\Request;

class ModeleActivitesController extends Controller
{
    public function index() {
		$modeleactivites = ModeleActivite::with(['groupeactivite'])->get();
		return view('modeleactivites.index', compact('modeleactivites'));
	}
	
    public function show($id)
    {
        $modeleactivite = ModeleActivite::with(['etapes', 'groupeactivite'])->findOrFail($id);
		$nbractivites = Activite::where('modele_id', $id)->where('valide', true)->count();
        //dd($modeleactivite, $nbractivites); die();
		return view('modeleactivites.show', compact('modeleactivite', 'nbractivites'));
    }
	
	public function create()
    {
		$groupeactivites = GroupeActivite::all();
        return view('modeleactivites.create', compact('groupeactivites'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|string|max:20',
            'nom' => 'required|string|max:100',
            'groupeactivite_id' => 'required|integer',
            'description' => 'nullable|string',
        ]);
		
        ModeleActivite::create($request->all());
		return redirect()->route('modeleactivites.index')->with('success', 'Données ajoutées avec succès.');
    }
	
	 public function edit($id)
    {
        $modeleactivite = ModeleActivite::findOrFail($id);
		$groupeactivites = GroupeActivite::all();
        return view('modeleactivites.edit', compact('modeleactivite', 'groupeactivites'));
    }

    public function update(Request $request, $id)
    {
        $m = ModeleActivite::findOrFail($id);
        $data = $request->validate([
            'code' => 'sometimes|string|max:20' . $m->id,
            'nom' => 'sometimes|string|max:100',
            'groupeactivite_id' => 'sometimes|integer',
            'description' => 'nullable|string',
        ]);
        $m->update($data);
        return redirect()->route('modeleactivites.index')->with('success', 'Type d’activités modifié avec succès.');
    }

    public function destroy($id) {
		ModeleActivite::findOrFail($id)->delete();
		
		try {
			$modele = ModeleActivite::findOrFail($id);
			$modele->delete();
			return redirect()->route('modeleactivites.index')->with('success', 'Type d’activités supprimé avec succès.');

		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
	}
	 
	public function actif($id)
    {
        $modeleactivite = ModeleActivite::findOrFail($id);
		$modeleactivite->is_active = !$modeleactivite->is_active;
		$modeleactivite->save();

        return redirect()->back()->with('success');
    } 
}
