<?php

namespace App\Http\Controllers;

use App\Models\PointFocal;
use Illuminate\Http\Request;

class PointfocalsController extends Controller
{
    public function index() { 	
	return PointFocal::all(); }
    public function show($id) {
	 return PointFocal::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'structure_id' => 'required|integer',
            'user_id' => 'required|integer',
            'datedebut' => 'required|date',
            'datefin' => 'nullable|date',
        ]);
        return PointFocal::create($data);
    }

    public function update(Request $request, $id)
    {
        $pf = PointFocal::findOrFail($id);
        $data = $request->validate([
            'structure_id' => 'sometimes|integer',
            'user_id' => 'sometimes|integer',
            'datedebut' => 'sometimes|date',
            'datefin' => 'nullable|date',
        ]);
        $pf->update($data);
        return $pf;
    }

    public function destroy($id) { 
	PointFocal::findOrFail($id)->delete(); 
	return response()->json(['message'=>'Point focal supprimé']); }
}

