<?php

namespace App\Http\Controllers;

use App\Models\PrevisionActivite;
use Illuminate\Http\Request;

class PrevisionActivitesController extends Controller
{
    public function index() {
	 return PrevisionActivite::all(); }
    public function show($id) { 
	return PrevisionActivite::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'ordreevaluation' => 'required|numeric',
            'dateevaluation' => 'required|date',
        ]);
        return PrevisionActivite::create($data);
    }

    public function update(Request $request, $id)
    {
        $p = PrevisionActivite::findOrFail($id);
        $data = $request->validate([
            'activite_id' => 'sometimes|integer',
            'ordreevaluation' => 'sometimes|numeric',
            'dateevaluation' => 'sometimes|date',
        ]);
        $p->update($data);
        return $p;
    }

    public function destroy($id) {
	 PrevisionActivite::findOrFail($id)->delete(); 
	return response()->json(['message'=>'Prévision Activité supprimée']); }
}
