@extends('layouts.app')
@section('title', 'Activités')

@section('content')
<div class="pagetitle">
  <h1>Liste des Activités</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Activités</li>
    </ol>
  </nav>
</div>
<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">Toutes les activités</h5>
      @php
    $usergroupId = Auth::user()->usergroup_id;
@endphp
@if($usergroupId != 3 && $usergroupId != 4)
	 <a href="{{ route('activites.create') }}" class="btn btn-primary mb-3">Activité</a>
@endif
     

<table class="table datatable">
        <thead>
          <tr>
            
            <th>Code & Nom</th>
		<th>Groupe</th>
            <th>Action</th>
			<th>Responsable</th>
			<th>Montant</th>
            <th>Actif</th>
            <th>Ouvert</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($activites as $a)
          <tr>
            
            <td>{{ $a->code }}:{{ $a->nom }}</td>
          
            <td>{{ $a->groupeactivite->nom ?? '-' }}</td>
			<td>{{ $a->action->nom ?? '-' }}</td>
			<td>{{ $a->structureresponsable->nom ?? '-' }}</td>
			<td>{{ $a->montant ? number_format($a->montant, 0, '', ' ') : '-' }}</td>
            <td>
             @if(Auth::user()->usergroup_id == 4)
				<button class="btn btn-sm {{ $a->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
				{{ $a->actif ? 'Oui' : 'Non' }}
				</button>
			@else
				<a href="{{ route('activites.actif', $a->id) }}" 
					class="btn btn-sm {{ $a->actif ? 'btn-success' : 'btn-secondary' }}">
					{{ $a->actif ? 'Oui' : 'Non' }}
				</a>
            @endif  
            </td>
            <td>
                 @if(Auth::user()->usergroup_id == 4)
        <button class="btn btn-sm {{ $a->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
            {{ $a->ouvert ? 'Ouvert' : 'Fermé' }}
        </button>
    @else
				<a href="{{ route('activites.ouvert', $a->id) }}" 
               class="btn btn-sm {{ $a->ouvert ? 'btn-success' : 'btn-secondary' }}">
              {{ $a->ouvert ? 'Ouvert' : 'Fermé' }}
            </a>
        @endif       
            </td>
            <td>
			 <a href="{{ route('activites.show', $a->id) }}" class="btn btn-info"><i class="bi bi-eye"></i></a>
          <a href="{{ route('activites.edit', $a->id) }}" class="btn btn-warning">
            <i class="bi bi-pen"></i>
          </a>
          @if($usergroupId != 3 && $usergroupId != 4)
          <a href="{{ route('activites.destroy', $a->id) }}"
   class="btn btn-danger"
   onclick="return confirm('Supprimer cette activité ?')">
   <i class="bi bi-trash"></i>
</a>
	
@endif

             
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</section>
@endsection
