<?php $__env->startSection('title', 'Programme'); ?>

<?php $__env->startSection('content'); ?>
 <div class="pagetitle">
    <h1>Détails Programme</h1>
    <nav>
		<ol class="breadcrumb">
		    <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
		    <li class="breadcrumb-item"><a href="<?php echo e(URL::to('programmes')); ?>">Programmes</a></li>
		    <li class="breadcrumb-item active">Détails</li>
		</ol>
    </nav>
</div><!-- End Page Title -->
<section class="section">
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h5 class="card-title">Détails du programme: <span id="details"></h5>
					<?php if(Session::has('status')): ?>
					<div class="col-md-3" style="margin-left:15%">
						<div class="card card-success shadow-sm">
							<div class="card-header">
							    <h3 class="card-title">Correct</h3>

							    <div class="card-tools">
									<button type="button" class="btn btn-tool" data-card-widget="remove">
									    <i class="fas fa-times"></i>
									</button>
							    </div>
							</div>
							<div class="card-body">
								<?php echo e(Session::get('status')); ?>

							</div>
						</div>
					</div>
					<?php endif; ?>
					<div class="card-body">
						<h2>Détails : <strong> <?php echo e($programme->nom); ?></strong> </h2>
						<hr>
						<div class="row">
							<a href="" class="nav-link">
							<!--<button type="button" class="btn btn-block btn-success btn-sm"><i class="nav-icon fas fa-print"></i>Imprimer</button> -->
							</a>
						</div>
						<div class="row">
							<div class="col-md-10">
								<div class="callout callout-primary">
									<h5><b><u>Informations générales</u></b></h5>
									<ul class="list-group list-group-unbordered mb-3">
										<li class="list-group-item">
											<b>Code  : </b> <a class="float-right">  <?php echo e($programme->code); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Intitulé  : </b> <a class="float-right">  <?php echo e($programme->nom); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Détails  : </b><br> <a class="float-right">  <?php echo e($programme->description); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Programme activé : </b> <a class="float-right">
											<?php if(Auth::user()->usergroup_id == 4): ?>
												<button class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
													<?php echo e($programme->actif ? 'OUI' : 'NON'); ?>

												</button>
											<?php else: ?>
												 <a href="<?php echo e(route('programmes.fonctactif', $programme->id)); ?>" 
													class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($programme->actif ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
											</a><br>
										</li>
										<li class="list-group-item">
											<b> Ouvert (en élaboration/revu) : </b> <a class="float-right">
											<?php if(Auth::user()->usergroup_id == 4): ?>
												<button class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
													<?php echo e($programme->ouvert ? 'OUI' : 'NON'); ?>

												</button>
											<?php else: ?>
												 <a href="<?php echo e(route('programmes.fonctouvert', $programme->id)); ?>" 
													class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($programme->ouvert ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
											</a><br>
										</li>
										<li class="list-group-item">
											<b>Responsable programme : </b> <a class="float-right">  
											<?php if(isset($programme->user->id)): ?>
												<?php echo e($programme->user->name); ?> (<?php echo e($programme->user->email); ?>)</a> 
												<a href="<?php echo e(route('programmes.rpremove', $programme->id)); ?>"> <i class="bi bi-danger" onclick="return confirm('Enlever ce RP?')">X</i> </a>
												<br>
											<?php else: ?>
												<?php echo e("Non désigné"); ?>

											<?php endif; ?>
											<a href="<?php echo e(route('users.rpcreate', ['level' => 'program', 'id' => $programme->id])); ?>" class="btn btn-warning">
												<i class="bi bi-plus-circle"></i>Choisir/Modifier le RP
											</a>
											
										</li>
									</ul>
								</div>
							</div>
						</div><hr><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Liste des actions</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Code</th>
											<th>Libellé</th>
											<th>Actif</th>
											<th>Ouvert</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<?php if($programme->ouvert && $programme->actif): ?>
											<h6 class="card-title"><a href="<?php echo e(route('actions.create', ['progid' => $programme->id])); ?>" class="btn btn-primary rounded-pill">
											<i class="bi bi-plus-circle"></i> Ajouter une action</a></h6>
										<?php endif; ?>
										<?php if(!is_null($programme->actions)): ?>
											<?php $__currentLoopData = $programme->actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($action->code); ?> </td>
												<td><?php echo e($action->nom); ?></td>
												<td><a href="<?php echo e(route('actions.actif', $action->id)); ?>" 
													class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($action->actif ? 'Oui' : 'Non'); ?>

												</a></td>
												<td><a href="<?php echo e(route('actions.ouvert', $action->id)); ?>" 
													class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($action->ouvert ? 'Ouvert' : 'Fermé'); ?>

												</a></td>
												<td>
													<a href="<?php echo e(route('actions.show', $action->id)); ?>" class="btn btn-info"><i class="bi bi-eye"></i></a>
													<a href="<?php echo e(route('actions.edit', $action->id)); ?>" class="btn btn-warning"><i class="bi bi-pen"></i></a>
													<a href="<?php echo e(route('actions.destroy', $action->id)); ?>" class="btn btn-danger" onclick="return confirm('Supprimer cette action ?')"><i class="bi bi-trash"></i></a>
												</td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div><hr>
                                                <div class="row">
							<div class="callout callout-primary">
								<h5><b><u><b>Historique des RPs</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Responsable</th>
											<th>Du : </th>
											<th>Au : </th>
										</tr>
									</thead>
									<tbody>
										<?php if(!is_null($programme->responsables)): ?>
											<?php $__currentLoopData = $programme->responsables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $responsable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($responsable->user); ?> </td>
												<td><?php echo e($responsable->datedebut); ?></td>
												<td><?php echo e($responsable->datefin?? 'En cours'); ?></td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\phaso\resources\views/programmes/show.blade.php ENDPATH**/ ?>