<?php $__env->startSection('title', 'Action'); ?>

<?php $__env->startSection('content'); ?>
 <div class="pagetitle">
    <h1>Détails Action</h1>
    <nav>
		<ol class="breadcrumb">
		    <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
		    <li class="breadcrumb-item"><a href="<?php echo e(route('programmes.show', $action->programme_id)); ?>">Détail programme</a></li>
		    <li class="breadcrumb-item active">Détails action</li>
		</ol>
    </nav>
</div><!-- End Page Title -->
<section class="section">
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h5 class="card-title">Détails de l'action: <span id="details"></h5>
					<?php if(Session::has('status')): ?>
					<div class="col-md-3" style="margin-left:15%">
						<div class="card card-success shadow-sm">
							<div class="card-header">
							    <h3 class="card-title">Correct</h3>

							    <div class="card-tools">
									<button type="button" class="btn btn-tool" data-card-widget="remove">
									    <i class="fas fa-times"></i>
									</button>
							    </div>
							</div>
							<div class="card-body">
								<?php echo e(Session::get('status')); ?>

							</div>
						</div>
					</div>
					<?php endif; ?>
					<div class="card-body">
						<h2>Détails : <strong> <?php echo e($action->nom); ?></strong> </h2>
						<hr>
						<div class="row">
							<a href="" class="nav-link">
							<!--<button type="button" class="btn btn-block btn-success btn-sm"><i class="nav-icon fas fa-print"></i>Imprimer</button> -->
							</a>
						</div>
						<div class="row">
							<div class="col-md-10">
								<div class="callout callout-primary">
									<h5><b><u>Informations générales</u></b></h5>
									<ul class="list-group list-group-unbordered mb-3">
										<li class="list-group-item">
											<b>Code  : </b> <a class="float-right">  <?php echo e($action->code); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Intitulé  : </b> <a class="float-right">  <?php echo e($action->nom); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Détails  : </b><br> <a class="float-right">  <?php echo e($action->description); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Action activé : </b> <a class="float-right">
											<?php if(Auth::user()->usergroup_id == 4): ?>
												<button class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
													<?php echo e($action->actif ? 'OUI' : 'NON'); ?>

												</button>
											<?php else: ?>
												 <a href="<?php echo e(route('actions.actif', $action->id)); ?>" 
													class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($action->actif ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
											</a><br>
										</li>
										<li class="list-group-item">
											<b> Ouvert (en élaboration/revu) : </b> <a class="float-right">
											<?php if(Auth::user()->usergroup_id == 4): ?>
												<button class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
													<?php echo e($action->ouvert ? 'OUI' : 'NON'); ?>

												</button>
											<?php else: ?>
												 <a href="<?php echo e(route('actions.ouvert', $action->id)); ?>" 
													class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($action->ouvert ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
											</a><br>
										</li>
									</ul>
								</div>
							</div>
						</div><hr><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Résultats de l'actions</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Libellé</th>
											<th>Description</th>
											<th>Action</th>
										</tr>
									</thead>
									<tbody>
										<?php if($action->ouvert && $action->actif): ?>
											<h6 class="card-title"><a href="<?php echo e(route('resultats.create', ['actionid' => $action->id])); ?>" class="btn btn-primary rounded-pill"><i class="bi bi-plus-circle"></i> Ajouter un  résultat</a></h6>
										<?php endif; ?>
										<?php if(!is_null($action->resultats)): ?>
											<?php $__currentLoopData = $action->resultats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resultat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($resultat->nom); ?> </td>
												<td><?php echo e($resultat->description); ?></td>
												<td><a href="<?php echo e(route('resultats.destroy', $resultat->id)); ?>"> 
												<i class="bi bi-danger" onclick="return confirm('Enlever ce RP?')">
													<i class="bi bi-trash"></i>
												</i> </a></td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Liste des activités</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Code</th>
											<th>Libellé</th>
											<th>Groupe d'activité</th>
											<th>Responsable</th>
											<th>Actif</th>
											<th>Ouvert</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<h6 class="card-title">
											<?php if($action->ouvert && $action->actif): ?>
												<a href="<?php echo e(route('activites.create', $action->id)); ?>" class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une activité
												</a>
											<?php endif; ?>
										</h6>
										<?php if(!is_null($action->activites)): ?>
											<?php $__currentLoopData = $action->activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($activite->code); ?> </td>
												<td><?php echo e($activite->nom); ?></td>
												<td><?php echo e($activite->groupeactivite->nom ?? '-'); ?></td>
												<td><?php echo e($activite->structureresponsable->nom ?? '-'); ?></td>
												<td><a href="<?php echo e(route('activites.actif', $activite->id)); ?>" 
													class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($activite->actif ? 'Oui' : 'Non'); ?>

												</a></td>
												<td><a href="<?php echo e(route('activites.ouvert', $activite->id)); ?>" 
													class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($action->ouvert ? 'Ouvert' : 'Fermé'); ?>

												</a></td>
												<td>
													<a href="<?php echo e(route('activites.show', $activite->id)); ?>" class="btn btn-info"><i class="bi bi-eye"></i></a>
													<a href="<?php echo e(route('activites.edit', $activite->id)); ?>" class="btn btn-warning"><i class="bi bi-pen"></i></a>
													<a href="<?php echo e(route('activites.destroy', $activite->id)); ?>" class="btn btn-danger" onclick="return confirm('Supprimer cette activite ?')"><i class="bi bi-trash"></i></a>
												</td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div><hr>
                        <div class="row">
							<div class="callout callout-primary">
								<h5><b><u><b>Liste des structures intervenant</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Structure</th>
											<th>Ministère</th>
											<th>Du : </th>
											<th>Au : </th>
											<th></th>
										</tr>
									</thead>
									<tbody>
										<?php
											$canAddStructure = $action->ouvert && $action->actif;
										?>
										<?php if($canAddStructure): ?>
											<h6 class="card-title">
												<a href="<?php echo e(route('structures.selecforaction', ['actionid' => $action->id, 'actionstate' => $canAddStructure])); ?>" 
												   class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une structure
												</a>
											</h6>
										<?php endif; ?>
										<?php if(!is_null($action->structures)): ?>
											<?php $__currentLoopData = $action->structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($structure->nom); ?> (<?php echo e($structure->code); ?>)</td>
												<td><?php echo e($structure->ministere->nom); ?> (<?php echo e($structure->ministere->code); ?>)</td>
												<td><?php echo e($structure->pivot->datedebut); ?></td>
												<td><?php echo e($structure->pivot->datefin?? 'En cours'); ?></td>
												<td> <a href="<?php echo e(route('structureactions.detach', $structure->pivot->id)); ?>" class="btn btn-info">X</a>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
						<div class="callout callout-primary">
								<h5><b><u><b>Historique des anciens intervenants</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Structure</th>
											<th>Ministère</th>
											<th>Du : </th>
											<th>Au : </th>
										</tr>
									</thead>
									<tbody>
										<?php if(!is_null($action->structurearchives)): ?>
											<?php $__currentLoopData = $action->structurearchives; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structureold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($structureold->nom); ?> (<?php echo e($structureold->code); ?>)</td>
												<td><?php echo e($structureold->ministere->nom); ?> (<?php echo e($structureold->ministere->code); ?>)</td>
												<td><?php echo e($structureold->pivot->datedebut); ?></td>
												<td><?php echo e($structureold->pivot->datefin); ?></td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/actions/show.blade.php ENDPATH**/ ?>