<?php $__env->startSection('title', 'Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Ajout d'une Activité</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Accueil</a></li>
      <li class="breadcrumb-item">Activités</li>
      <li class="breadcrumb-item active">Ajout</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Ajouter une activité</h5>

          <form method="POST" action="<?php echo e(route('activites.store')); ?>">
            <?php echo csrf_field(); ?>
			<div class="row g-3">
<div class="col-md-6">
                <label class="form-label"><b>CSD</b></label>
                <select id="csd_id" class="form-control" required>
                  <option value="">-- Choisir un CSD --</option>
                  <?php $__currentLoopData = $csds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $csd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($csd->id); ?>"><?php echo e($csd->nom); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
 <div class="col-md-6">
                <label class="form-label"><b>Groupe d'activité</b></label>
                <select name="groupe_id" id="groupe_id" class="form-control" required>
                  <option value="">-- Choisir un groupe --</option>
                </select>
              </div>

			</div>
			<div class="row g-3">
              <div class="col-md-3">
                <label class="form-label"><b>Code</b></label>
                  <input type="text" class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="code" name="code"  value="<?php echo e(old('code')); ?>" required>
            <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="col-md-9">
                <label class="form-label"><b>Nom</b></label>
                 <input type="text" class="form-control <?php $__errorArgs = ['nom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nom" name="nom"  value="<?php echo e(old('nom')); ?>" required>
        <?php $__errorArgs = ['nom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date début</b></label>
             
                 <input type="date" class="form-control <?php $__errorArgs = ['datedebut'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="datedebut" name="datedebut"  value="<?php echo e(old('datedebut')); ?>" required>
        <?php $__errorArgs = ['datedebut'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date fin</b></label>
                 <input type="date" class="form-control <?php $__errorArgs = ['datefin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="datefin" name="datefin"  value="<?php echo e(old('datefin')); ?>" required>
        <?php $__errorArgs = ['datefin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Montant</b></label>
               
                 <input type="number" class="form-control <?php $__errorArgs = ['montant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="montant" name="montant"  value="<?php echo e(old('montant')); ?>" required>
        <?php $__errorArgs = ['montant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Structure responsable</b></label>
                <select name="structure_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($s->id); ?>"><?php echo e($s->nom); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Action</b></label>
                <select name="action_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($a->id); ?>" <?php echo e($actionid == $a->id ? 'selected' : ''); ?>>
					<?php echo e($a->nom); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
                <button type="reset" class="btn btn-secondary">Réinitialiser</button>
              </div>

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const csdSelect = document.getElementById('csd_id');
    const groupeSelect = document.getElementById('groupe_id');

    csdSelect.addEventListener('change', function () {
        const csdId = this.value;
        groupeSelect.innerHTML = '<option value="">-- Chargement... --</option>';

        if (csdId) {
            fetch(`/activites/groupes/${csdId}`)
                .then(response => response.json())
                .then(data => {
                    groupeSelect.innerHTML = '<option value="">-- Choisir un groupe --</option>';
                    data.forEach(groupe => {
                        const option = document.createElement('option');
                        option.value = groupe.id;
                        option.textContent = groupe.nom;
                        groupeSelect.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Erreur:', error);
                    groupeSelect.innerHTML = '<option value="">-- Erreur de chargement --</option>';
                });
        } else {
            groupeSelect.innerHTML = '<option value="">-- Choisir un groupe --</option>';
        }
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/create.blade.php ENDPATH**/ ?>